#' Abstract class that represents an SQL statement.
#'
#' This abstract class represents an SQL statement (FROM, SELECT, WHERE, ...).
#' Note that expressions (Expr class) are a particular type of Statement in
#' sqlq.
#'
#' @examples
#' # No example provided, as this class is abstract.
#'
#' @import R6
#' @export
Statement <- R6::R6Class("Statement",
  public = list(

    #' @description
    #' Initializer
    #' @return Nothing.
    initialize = function() {
    },

    #' @description
    #' Generates the list of tokens representing this statement.
    #' @return A list of Token objects.
    getTokens = function() {
      stop("Not implemented.", call. = FALSE)
    },

    #' @description
    #' Generates the string representation of this statement.
    #' @return A string containing the SQL expression.
    toString = function() {
      # Get tokens and convert them to strings
      tokens <- vapply(self$getTokens(), function(x) x$toString(),
                       FUN.VALUE = "")

      return(paste(tokens, collapse = ""))
    }
  )
)
