#' This class represents the IS NULL test.
#'
#' Used to test if a field is NULL inside a WHERE clause.
#'
#' @examples
#' # To generate a NULL test:
#' ExprIsNull$new(ExprField$new("title"))
#'
#' @import R6
#' @include ExprComp.R
#' @export
ExprIsNull <- R6::R6Class("ExprIsNull",
  inherit = ExprComp,
  public = list(

    #' @description
    #' Initializer.
    #' @param expr The Expr instance to test.
    #' @param ... Arguments to pass to parent class.
    #' @return Nothing.
    initialize = function(expr, ...) {
      super$initialize(...)
      chk::chk_is(expr, "Expr")
      private$expr <- expr

      return(invisible(NULL))
    },

    #' @description
    #' Generates the list of tokens representing this statement.
    #' @return A list of Token objects.
    getTokens = function() {
      tokens <- list()
      if (private$paren) {
        tokens <- c(tokens, .lparen)
      }
      tokens <- c(tokens, private$expr$getTokens(), .spc, .is, .spc, .null)
      if (private$paren) {
        tokens <- c(tokens, .rparen)
      }
      return(tokens)
    }
  ),
  private = list(
    expr = NULL
  )
)
