% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_sql.R
\name{orbital.lm_sql_result}
\alias{orbital.lm_sql_result}
\title{Convert an lm_sql_result to an orbital object}
\usage{
orbital.lm_sql_result(x, ..., prefix = ".pred")
}
\arguments{
\item{x}{An `lm_sql_result` object.}

\item{...}{Not used.}

\item{prefix}{Column name for predictions. Defaults to `".pred"`.}
}
\value{
An `orbital_class` object.
}
\description{
Creates an orbital object from a fitted SQL linear model,
  enabling in-database predictions without pulling data into R.
}
\details{
Builds a single prediction expression by combining the fitted
  coefficients with the R expressions stored in `term_expressions`. For
  categorical predictors, the expression includes `ifelse()` calls that
  dbplyr translates to SQL `CASE WHEN`. The resulting `orbital_class`
  object can be used with [orbital::predict()] to get predictions or
  [orbital::augment()] to append a `.pred` column to a database table.
}
