\name{heuSearch}
\alias{heuSearch}
\title{Heuristic model search}

\description{
This function performs an heuristic model search, to select which type of sender and receiver effects should be included in the model. The sender/receiver effects can be either absent, constant or variable.
}

\usage{
heuSearch( Y, D = 2, nrep = 1000)
}

\arguments{
\item{Y}{A three-dimensional array or list of \eqn{(n\times n)}{n x n} adjacency matrices composing the multidimensional network. A list will be converted to an array. If an array, the dimension of \code{Y} must be \code{(n,n,K)}, where \code{n} is the number of nodes and \code{K} the number of networks. Structural missing values (\code{NA}) are allowed, but no imputation is performed; see details.}

\item{D}{The dimension of the latent space, with \code{D > 0}. The default value is \code{D = 2}.}

\item{nrep}{ The number of datasets to be simulated for each model type. By default \code{nrep = 1000}.}
}

\value{
The function returns a list containing the following objects:
\itemize{
\item{\code{bestModel}}{ The selected combination of sender and receiver effects.}
\item{\code{modelProbs}}{ The estimated probabilities that \code{Y} has been generated by the models corresponding to all the sender/receiver effects combinations. }
\item{\code{modClass}}{ The model-specific accuracies of the classifier. Rows correspond to the predicted model, while columns to the model the simualted data have been generated from. }
}
}

\details{
The function performs an heuristic model search for the type of sender/receiver effects to be included in the model for the multidimensional network \code{Y} with \eqn{n}{n} nodes and \eqn{K}{K} networks.

The function simulates \code{nrep} different multidimensional networks of dimensions \eqn{(n, K)}{(n, K)} from the nine models arising from different combinations of sender/receiver effects: \code{"NN"}, \code{"CN"}, \code{"NC"}, \code{"CC"}, \code{"VN"}, \code{"NV"}, \code{"VC"}, \code{"CV"}, \code{"VV"}. The first letter indicates the sender effect type, while the second letter denotes the receiver effect type. The effects can be constrained across the networks, with \code{"N"} indicating no effects, \code{"C"} constant effects and \code{"V"} variable effects. The simulated multidimensional networks are then used to train a classifier, which is employed to assign the observed multiplex \code{Y} to the most plausible node-specific effect model.
}


\references{
D'Angelo, S. and Murphy, T. B. and Alfò, M. (2018). Latent space modeling of multidimensional networks with application to the exchange of votes in the Eurovision Song Contest. \href{https://arxiv.org/abs/1803.07166}{arXiv}.

D'Angelo, S. and Alfò, M. and Murphy, T. B. (2018). Node-specific effects in latent space modelling of multidimensional networks. \href{https://arxiv.org/abs/1807.03874}{arXiv}.
}

\examples{
data(vickers)
#heuS <- heuSearch( vickers, D = 2, nrep = 10) # nrep is set to 10 as an example.
}

\seealso{
\code{\link{multiNet}}
}

