% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manlysa.R
\name{manlysalpha}
\alias{manlysalpha}
\title{Manly's alpha feeding preference (Chesson 1978).
Returns Manly'as alpha index from vectors of initial and final food item counts.}
\usage{
manlysalpha(initial, consumed, stand = FALSE, perc = FALSE,
  deplete = TRUE)
}
\arguments{
\item{initial}{A vector of initial food items counts available to the organism in the environment}

\item{consumed}{A vector of food items consumed by the organism}

\item{stand}{Converts values with highest standardized to "1"? Defaults to FALSE.}

\item{perc}{Converts values to percentages? Defaults to FALSE.}

\item{deplete}{For use in experiments where food sources deplete? Defaults to TRUE.}
}
\description{
Manly's alpha feeding preference (Chesson 1978).
Returns Manly's alpha index from vectors of initial and final food item counts.
}
\examples{
initial_prey_count <- c(10,10,10,10,10,10)
number_prey_consumed <- c(9,8,1,3,5,9)
manlysalpha(initial = initial_prey_count, consumed = number_prey_consumed,
stand = TRUE, perc = FALSE, deplete = TRUE)

manlysalpha(initial = initial_prey_count, consumed = number_prey_consumed,
stand = TRUE, perc = TRUE, deplete = TRUE)

}
\keyword{Manly's}
\keyword{alpha}
\keyword{preference}
\keyword{selectivity}
