% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-duplicate-forecasts.R
\name{get_duplicate_forecasts}
\alias{get_duplicate_forecasts}
\title{Find duplicate forecasts}
\usage{
get_duplicate_forecasts(data, forecast_unit = NULL, counts = FALSE)
}
\arguments{
\item{data}{A data.frame (or similar) with predicted and observed values.
See the details section of for additional information
on the required input format.}

\item{forecast_unit}{(optional) Name of the columns in \code{data} (after
any renaming of columns) that denote the unit of a
single forecast. See \code{\link[=get_forecast_unit]{get_forecast_unit()}} for details.
If \code{NULL} (the default), all columns that are not required columns are
assumed to form the unit of a single forecast. If specified, all columns
that are not part of the forecast unit (or required columns) will be removed.}

\item{counts}{Should the output show the number of duplicates per forecast
unit instead of the individual duplicated rows? Default is \code{FALSE}.}
}
\value{
A data.frame with all rows for which a duplicate forecast was found
}
\description{
Internal helper function to identify duplicate forecasts, i.e.
instances where there is more than one forecast for the same prediction
target.
}
\examples{
example <- rbind(example_quantile, example_quantile[1000:1010])
get_duplicate_forecasts(example)
}
\keyword{diagnose-inputs}
