% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Seurat_Iterative.R
\name{Iterate_Meta_Highlight_Plot}
\alias{Iterate_Meta_Highlight_Plot}
\title{Iterate Meta Highlight Plot}
\usage{
Iterate_Meta_Highlight_Plot(
  seurat_object,
  meta_data_column,
  new_meta_order = NULL,
  meta_data_sort = TRUE,
  highlight_color = "navy",
  background_color = "lightgray",
  pt.size = NULL,
  no_legend = FALSE,
  title_prefix = NULL,
  reduction = NULL,
  file_path = NULL,
  file_name = NULL,
  file_type = NULL,
  single_pdf = FALSE,
  output_width = NULL,
  output_height = NULL,
  dpi = 600,
  raster = NULL,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{meta_data_column}{Name of the column in \code{seurat_object@meta.data} slot to pull value from for highlighting.}

\item{new_meta_order}{The order in which to plot each level within \code{meta_data_column} if \code{single_PDF} is TRUE.}

\item{meta_data_sort}{logical.  Whether or not to sort and relevel the levels in \code{meta_data_column} if
\code{single_PDF} is TRUE.  Default is TRUE.}

\item{highlight_color}{Color to highlight cells (default "navy").  Can provide either single color to use for
all clusters/plots or a vector of colors equal to the number of clusters to use (in order) for the clusters/plots.}

\item{background_color}{non-highlighted cell colors.}

\item{pt.size}{point size for both highlighted cluster and background.}

\item{no_legend}{logical, whether or not to remove plot legend and move to plot title.  Default is FALSE.}

\item{title_prefix}{Value that should be used for plot title prefix if \code{no_legend = TRUE}.
If NULL the value of \code{meta_data_column} will be used.  Default is NULL.}

\item{reduction}{Dimensionality Reduction to use (if NULL then defaults to Object default).}

\item{file_path}{directory file path and/or file name prefix.  Defaults to current wd.}

\item{file_name}{name suffix to append after sample name.}

\item{file_type}{File type to save output as.  Must be one of following: ".pdf", ".png", ".tiff", ".jpeg", or ".svg".}

\item{single_pdf}{saves all plots to single PDF file (default = FALSE).  `file_type`` must be .pdf.}

\item{output_width}{the width (in inches) for output page size.  Default is NULL.}

\item{output_height}{the height (in inches) for output page size.  Default is NULL.}

\item{dpi}{dpi for image saving.}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 cells.}

\item{...}{Extra parameters passed to\code{\link[Seurat]{DimPlot}}.}
}
\value{
Saved plots
}
\description{
Iterate the create plots with meta data variable of interest highlighted.
}
\examples{
\dontrun{
Iterate_Meta_Highlight_Plot(seurat_object = object, meta_data_column = "sample_id",
highlight_color = "navy", background_color = "lightgray", file_path = "path/",
file_name = "name", file_type = ".pdf", single_pdf = TRUE)
}

}
\concept{iterative_plotting}
