% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactCheckbox.R
\name{checkboxStyle}
\alias{checkboxStyle}
\title{Checkbox style.}
\usage{
checkboxStyle(
  checked = NULL,
  checked_hover = NULL,
  unchecked = NULL,
  unchecked_hover = NULL,
  indeterminate = NULL,
  indeterminate_hover = NULL
)
}
\arguments{
\item{checked}{styles for the checkbox in checked state}

\item{checked_hover}{styles for the checkbox in checked state on hover}

\item{unchecked}{styles for the checkbox in unchecked state}

\item{unchecked_hover}{styles for the checkbox in unchecked state on hover}

\item{indeterminate}{styles for the checkbox in indeterminate state (for
the head checkbox)}

\item{indeterminate_hover}{styles for the checkbox in indeterminate state
on hover}
}
\value{
A named list, to be used in \code{\link{reactCheckboxesInput}}.
}
\description{
Define CSS styles for a checkbox.
}
\examples{
library(htmltools) # provides the convenient function `css`
checkboxStyle(
  checked = css(
    background.color = "rgba(255, 82, 82, 0.87)",
    border.color = "black"
  ),
  checked_hover = css(
    background.color = "darkred",
    border.color = "darkred"
  )
)
}
