% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalTree.R
\name{treeFromInterval}
\alias{treeFromInterval}
\title{treeFromInterval}
\usage{
treeFromInterval(interval_list)
}
\arguments{
\item{interval_list}{a list of Interval objects}
}
\value{
a list object representing a binary interval tree
}
\description{
Method for constructing interval tree for a list of Interval objects. A node in the tree is a list object.
As the leftChild and rightChild of each node are nodes themselves, a binary interval tree stored in a
recursive list will be produced if this function is executed successfully.
}
\examples{
i1 <- new("Interval", start=1.1,end=1.2, key="dummy1")
i2 <- new("Interval", start=-1.1,end=1.2, key="dummy2")
i3 <- new("Interval", start=-10.1,end=-1.2, key="dummy3")
i4 <- new("Interval", start=-1.1,end=1.2, key="dummy4")
i5 <- new("Interval", start=-10,end=2, key="dummy5")
i6 <- new("Interval", start=-8,end=-5, key="dummy6")
myList <- list(i1, i2, i3, i4, i5, i6)
atree <- treeFromInterval(myList)
}
