% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalTree.R
\name{intersectInterval}
\alias{intersectInterval}
\title{intersectInterval}
\usage{
intersectInterval(aTree, someNumbers)
}
\arguments{
\item{aTree}{a list object representing an interval tree}

\item{someNumbers}{a vector of one or two numbers to test for overlap. If two numbers are provided, they are treated as
an interval (start, end).}
}
\value{
a list of vectors. Each vector contains (name, start, end) of an interval
}
\description{
Method for searching the interval tree. Given a single number or an ordered pair of numbers denoting the start and end of an interval,
all intervals that overlapping the query interval in the interval tree will be retrieved.
}
\examples{
i1 <- new("Interval", start=1.1,end=1.2, key="dummy1")
i2 <- new("Interval", start=-1.1,end=1.2, key="dummy2")
i3 <- new("Interval", start=-10.1,end=-1.2, key="dummy3")
i4 <- new("Interval", start=-1.1,end=1.2, key="dummy4")
i5 <- new("Interval", start=-10,end=2, key="dummy5")
i6 <- new("Interval", start=-8,end=-5, key="dummy6")

myList <- list(i1, i2, i3, i4, i5, i6)
atree <- treeFromInterval(myList)
\dontrun{
intersectInterval(atree, c(-16, -26)) # generate an error
}
intersectInterval(atree, c(1, 5))
intersectInterval(atree, c(-12, 15))
intersectInterval(atree, 0)
}
