% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalTree.R
\name{insert}
\alias{insert}
\title{insert}
\usage{
insert(aTree, anInterval)
}
\arguments{
\item{aTree}{an interval tree (a list object)}

\item{anInterval}{an Interval object}
}
\value{
a list object, representing a binary interval tree
}
\description{
Method for inserting an Interval into an interval tree (a recursive list). The structure of the final
tree is invariant of the order of insertion. Tree balancing is not implemented, therefore, the
resulting tree may not be balanced.
}
\examples{
i1 <- new("Interval", start=1.1,end=1.2, key="dummy1")
i2 <- new("Interval", start=-1.1,end=1.2, key="dummy2")
i3 <- new("Interval", start=-10.1,end=-1.2, key="dummy3")
i4 <- new("Interval", start=-1.1,end=1.2, key="dummy4")
i5 <- new("Interval", start=-10,end=2, key="dummy5")
i6 <- new("Interval", start=-8,end=-5, key="dummy6")
i7 <- new("Interval", start=80,end=100, key="dummy7")
i8 <- new("Interval", start=-80,end=-15, key="dummy8")

atree <- list()
atree <- insert(atree, i1)
atree <- insert(atree, i2)
atree <- insert(atree, i3)
atree <- insert(atree, i4)
atree <- insert(atree, i5)
atree <- insert(atree, i6)
atree <- insert(atree, i7)
atree <- insert(atree, i8)

intersectInterval(atree, 85)
intersectInterval(atree, 0)
intersectInterval(atree, c(-70, -9))
\dontrun{
intersectInterval(atree, c(80,0)) ## generate an error
}
}
