% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TblSqlSource.R
\name{TblSqlSource}
\alias{TblSqlSource}
\title{Data Source: SQL Tibble}
\description{
A DataSource implementation for lazy SQL tibbles connected to databases via
\code{\link[dbplyr:tbl_sql]{dbplyr::tbl_sql()}} or \code{\link[dplyr:sql]{dplyr::sql()}}.
}
\examples{
\dontshow{if (rlang::is_installed("dbplyr") && rlang::is_installed("dplyr") && rlang::is_installed("duckdb")) withAutoprint(\{ # examplesIf}
con <- DBI::dbConnect(duckdb::duckdb())
DBI::dbWriteTable(con, "mtcars", mtcars)

mtcars_source <- TblSqlSource$new(dplyr::tbl(con, "mtcars"))
mtcars_source$get_db_type()  # "DuckDB"

result <- mtcars_source$execute_query("SELECT * FROM mtcars WHERE cyl > 4")

# Note, the result is not the *full* data frame, but a lazy SQL tibble
result

# You can chain this result into a dplyr pipeline
dplyr::count(result, cyl, gear)

# Or collect the entire data frame into local memory
dplyr::collect(result)

# Finally, clean up when done with the database (closes the DB connection)
mtcars_source$cleanup()
\dontshow{\}) # examplesIf}
}
\section{Super classes}{
\code{\link[querychat:DataSource]{querychat::DataSource}} -> \code{\link[querychat:DBISource]{querychat::DBISource}} -> \code{TblSqlSource}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{table_name}}{Name of the table to be used in SQL queries}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TblSqlSource-new}{\code{TblSqlSource$new()}}
\item \href{#method-TblSqlSource-get_db_type}{\code{TblSqlSource$get_db_type()}}
\item \href{#method-TblSqlSource-get_schema}{\code{TblSqlSource$get_schema()}}
\item \href{#method-TblSqlSource-execute_query}{\code{TblSqlSource$execute_query()}}
\item \href{#method-TblSqlSource-test_query}{\code{TblSqlSource$test_query()}}
\item \href{#method-TblSqlSource-prep_query}{\code{TblSqlSource$prep_query()}}
\item \href{#method-TblSqlSource-get_data}{\code{TblSqlSource$get_data()}}
\item \href{#method-TblSqlSource-cleanup}{\code{TblSqlSource$cleanup()}}
\item \href{#method-TblSqlSource-clone}{\code{TblSqlSource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TblSqlSource-new"></a>}}
\if{latex}{\out{\hypertarget{method-TblSqlSource-new}{}}}
\subsection{Method \code{new()}}{
Create a new TblSqlSource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TblSqlSource$new(tbl, table_name = missing_arg())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tbl}}{A \code{\link[dbplyr:tbl_sql]{dbplyr::tbl_sql()}} (or SQL tibble via \code{\link[dplyr:tbl]{dplyr::tbl()}}).}

\item{\code{table_name}}{Name of the table in the database. Can be a character
string, or will be inferred from the \code{tbl} argument, if possible.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new TblSqlSource object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TblSqlSource-get_db_type"></a>}}
\if{latex}{\out{\hypertarget{method-TblSqlSource-get_db_type}{}}}
\subsection{Method \code{get_db_type()}}{
Get the database type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TblSqlSource$get_db_type()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A string describing the database type (e.g., "DuckDB", "SQLite")
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TblSqlSource-get_schema"></a>}}
\if{latex}{\out{\hypertarget{method-TblSqlSource-get_schema}{}}}
\subsection{Method \code{get_schema()}}{
Get schema information about the table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TblSqlSource$get_schema(categorical_threshold = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{categorical_threshold}}{Maximum number of unique values for a text
column to be considered categorical}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A string containing schema information formatted for LLM prompts
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TblSqlSource-execute_query"></a>}}
\if{latex}{\out{\hypertarget{method-TblSqlSource-execute_query}{}}}
\subsection{Method \code{execute_query()}}{
Execute a SQL query and return results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TblSqlSource$execute_query(query)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{SQL query string to execute}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame containing query results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TblSqlSource-test_query"></a>}}
\if{latex}{\out{\hypertarget{method-TblSqlSource-test_query}{}}}
\subsection{Method \code{test_query()}}{
Test a SQL query by fetching only one row
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TblSqlSource$test_query(query, require_all_columns = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{SQL query string to test}

\item{\code{require_all_columns}}{If \code{TRUE}, validates that the result includes
all original table columns (default: \code{FALSE})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame containing one row of results (or empty if no matches)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TblSqlSource-prep_query"></a>}}
\if{latex}{\out{\hypertarget{method-TblSqlSource-prep_query}{}}}
\subsection{Method \code{prep_query()}}{
Prepare a generic \verb{SELECT * FROM ____} query to work with the SQL tibble
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TblSqlSource$prep_query(query)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{SQL query as a string}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A complete SQL query string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TblSqlSource-get_data"></a>}}
\if{latex}{\out{\hypertarget{method-TblSqlSource-get_data}{}}}
\subsection{Method \code{get_data()}}{
Get the unfiltered data as a SQL tibble
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TblSqlSource$get_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{\link[dbplyr:tbl_sql]{dbplyr::tbl_sql()}} containing the original, unfiltered data
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TblSqlSource-cleanup"></a>}}
\if{latex}{\out{\hypertarget{method-TblSqlSource-cleanup}{}}}
\subsection{Method \code{cleanup()}}{
Clean up resources (close connections, etc.)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TblSqlSource$cleanup()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
NULL (invisibly)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TblSqlSource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TblSqlSource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TblSqlSource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
