% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pracSig13.R
\name{pracSig13}
\alias{pracSig13}
\title{Compute thirteen measures of practical significance}
\usage{
pracSig13(y, bigx, yes13 = rep(1, 13), verbo = FALSE)
}
\arguments{
\item{y}{{input dependent variable data as a vector}}

\item{bigx}{{input matrix of p regressor variables}}

\item{yes13}{{vector of ones to compute respective
13 measures m1 to m13. Default is all ones to compute all
e.g., yes13[10]=0 means do not compute the m10 method.}}

\item{verbo}{{logical to print results along the way default=FALSE}}
}
\value{
output matrix (p x 13) containing m1 to m13
criteria (numerical measures of practical significance)
along columns
and a row for each regressor (excluding the intercept).
}
\description{
Thirteen methods are denoted m1 to m13. Each
yields p numbers when there are p regressors denoted xi.
m1=OLS coefficient slopes. m2= t-stat of each slope.
m3= beta coefficients OLS after all variables have
mean zero and sd=1.
m4= Pearson correlation coefficient between y and xi (only two
variables at a time, assuming linearity).
Let r*(y|xi) denote the generalized correlation coefficient allowing
for nonlinearity from Vinod (2021, 2022). It does not equal
analogous r*(xi|y). The larger of the two,
max(r*(y|xi), r*(xi|y)), is given by
the function depMeas() from the 'generalCorr' package.
m5= depMeas, which allows nonlinearity. m5 is not comprehensive
because it measures only two  variables, y and xi, at a time.
m6= generalized partial correlation coefficient or
GPCC. This is the first comprehensive measure
of practical significance.
m7=a generalization of psychologists' "effect size" after incorporating
the nonlinear effect of other variables.
m8= local linear partial (dy/dxi) using the 'np' package
for kernel regressions and local linear derivatives.
m9= partial derivative (dy/dxi) using the 'NNS' package.
m10=importance measure using NNS.boost() function of 'NNS.'
m11=Shapley Value measure of importance (cooperative game theory).
m12 and m13= two versions of the random forest algorithm
measuring the importance of regressors.
}
\details{
If m6, m10 slow down computations, we recommend setting
yes13[6]=0=yes13[10] to turn off slowcomputation of m6 and m10
at least initially to get quick answers for other m's.
}
\note{
needs the function kern(), which requires package 'np'.
also needs 'NNS', 'randomForest', packages.

The machine learning methods are subject to random seeds.
For some seed values, m10 values from NNS.boost() become
degenerate and are reported as NA or missing. In that case
the average ranking output r613 from reportRank() needs manual adjustments.
}
\references{
Vinod, H. D."Generalized Correlation and Kernel Causality with
 Applications in Development Economics" in Communications in
 Statistics -Simulation and Computation, 2015,
 \doi{10.1080/03610918.2015.1122048}

Vinod, H. D.", "Generalized Correlations and Instantaneous Causality
 for Data Pairs Benchmark," (March 8, 2015).
  \url{https://www.ssrn.com/abstract=2574891}

Vinod, H. D. “Generalized, Partial and Canonical
Correlation Coefficients,” Computational Economics
(2021) SpringerLink vol. 59, pp.1-28.
URL https://link.springer.com/article/10.1007/s10614-021-10190-x

Vinod, H. D. “Kernel regression coefficients for practical
significance," Journal of Risk and Financial Management
15(1), 2022 pp.1-13. https://doi.org/10.3390/jrfm15010032

Vinod, H. D.", "Hands-On Intermediate Econometrics
Using R"  (2022) World Scientific Publishers: Hackensack, NJ.
\url{https://www.worldscientific.com/worldscibooks/10.1142/12831}
}
\seealso{
See Also as \code{\link{effSizCut}},

See Also as \code{\link{reportRank}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\keyword{Forest}
\keyword{GPCC}
\keyword{Random}
\keyword{Shapley}
\keyword{Value}
