% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_trace}
\alias{add_trace}
\alias{add_markers}
\alias{add_text}
\alias{add_paths}
\alias{add_lines}
\alias{add_segments}
\alias{add_polygons}
\alias{add_sf}
\alias{add_table}
\alias{add_ribbons}
\alias{add_image}
\alias{add_area}
\alias{add_pie}
\alias{add_bars}
\alias{add_histogram}
\alias{add_histogram2d}
\alias{add_histogram2dcontour}
\alias{add_heatmap}
\alias{add_contour}
\alias{add_boxplot}
\alias{add_surface}
\alias{add_mesh}
\alias{add_scattergeo}
\alias{add_choropleth}
\title{Add trace(s) to a plotly visualization}
\usage{
add_trace(p, ..., data = NULL, inherit = TRUE)

add_markers(p, x = NULL, y = NULL, z = NULL, ..., data = NULL, inherit = TRUE)

add_text(
  p,
  x = NULL,
  y = NULL,
  z = NULL,
  text = NULL,
  ...,
  data = NULL,
  inherit = TRUE
)

add_paths(p, x = NULL, y = NULL, z = NULL, ..., data = NULL, inherit = TRUE)

add_lines(p, x = NULL, y = NULL, z = NULL, ..., data = NULL, inherit = TRUE)

add_segments(
  p,
  x = NULL,
  y = NULL,
  xend = NULL,
  yend = NULL,
  ...,
  data = NULL,
  inherit = TRUE
)

add_polygons(p, x = NULL, y = NULL, ..., data = NULL, inherit = TRUE)

add_sf(p, ..., x = ~x, y = ~y, data = NULL, inherit = TRUE)

add_table(p, ..., rownames = TRUE, data = NULL, inherit = TRUE)

add_ribbons(
  p,
  x = NULL,
  ymin = NULL,
  ymax = NULL,
  ...,
  data = NULL,
  inherit = TRUE
)

add_image(p, z = NULL, colormodel = NULL, ..., data = NULL, inherit = TRUE)

add_area(p, r = NULL, theta = NULL, t = NULL, ..., data = NULL, inherit = TRUE)

add_pie(p, values = NULL, labels = NULL, ..., data = NULL, inherit = TRUE)

add_bars(p, x = NULL, y = NULL, ..., data = NULL, inherit = TRUE)

add_histogram(p, x = NULL, y = NULL, ..., data = NULL, inherit = TRUE)

add_histogram2d(
  p,
  x = NULL,
  y = NULL,
  z = NULL,
  ...,
  data = NULL,
  inherit = TRUE
)

add_histogram2dcontour(
  p,
  x = NULL,
  y = NULL,
  z = NULL,
  ...,
  data = NULL,
  inherit = TRUE
)

add_heatmap(p, x = NULL, y = NULL, z = NULL, ..., data = NULL, inherit = TRUE)

add_contour(p, z = NULL, ..., data = NULL, inherit = TRUE)

add_boxplot(p, x = NULL, y = NULL, ..., data = NULL, inherit = TRUE)

add_surface(p, z = NULL, ..., data = NULL, inherit = TRUE)

add_mesh(p, x = NULL, y = NULL, z = NULL, ..., data = NULL, inherit = TRUE)

add_scattergeo(p, ...)

add_choropleth(p, z = NULL, ..., data = NULL, inherit = TRUE)
}
\arguments{
\item{p}{a plotly object}

\item{...}{Arguments (i.e., attributes) passed along to the trace \code{type}.
See \code{\link[=schema]{schema()}} for a list of acceptable attributes for a given trace \code{type}
(by going to \code{traces} -> \code{type} -> \code{attributes}). Note that attributes
provided at this level may override other arguments
(e.g. \code{plot_ly(x = 1:10, y = 1:10, color = I("red"), marker = list(color = "blue"))}).}

\item{data}{A data frame (optional) or \link[crosstalk:SharedData]{crosstalk::SharedData} object.}

\item{inherit}{inherit attributes from \code{\link[=plot_ly]{plot_ly()}}?}

\item{x}{the x variable.}

\item{y}{the y variable.}

\item{z}{a numeric matrix (unless \code{\link[=add_image]{add_image()}}, which wants a raster object, see \code{\link[=as.raster]{as.raster()}}).}

\item{text}{textual labels.}

\item{xend}{"final" x position (in this context, x represents "start")}

\item{yend}{"final" y position (in this context, y represents "start")}

\item{rownames}{whether or not to display the rownames of \code{data}.}

\item{ymin}{a variable used to define the lower boundary of a polygon.}

\item{ymax}{a variable used to define the upper boundary of a polygon.}

\item{colormodel}{Sets the colormodel for image traces if \code{z} is not a raster object.
If \code{z} is a raster object (see \code{\link[=as.raster]{as.raster()}}), the \code{'rgba'} colormodel is always used.}

\item{r}{Sets the radial coordinates.}

\item{theta}{Sets the angular coordinates.}

\item{t}{Deprecated. Use \code{theta} instead.}

\item{values}{the value to associated with each slice of the pie.}

\item{labels}{the labels (categories) corresponding to \code{values}.}
}
\description{
Add trace(s) to a plotly visualization
}
\examples{
\dontshow{if (interactive() || !identical(.Platform$OS.type, "windows")) withAutoprint(\{ # examplesIf}

# the `plot_ly()` function initiates an object, and if no trace type
# is specified, it sets a sensible default
p <- plot_ly(economics, x = ~date, y = ~uempmed)
p

# some `add_*()` functions are a specific case of a trace type
# for example, `add_markers()` is a scatter trace with mode of markers
add_markers(p)

# scatter trace with mode of text
add_text(p, text = "\%")

# scatter trace with mode of lines 
add_paths(p)

# like `add_paths()`, but ensures points are connected according to `x`
add_lines(p)

# if you prefer to work with plotly.js more directly, can always
# use `add_trace()` and specify the type yourself
add_trace(p, type = "scatter", mode = "markers+lines")

# mappings provided to `plot_ly()` are "global", but can be overwritten
plot_ly(economics, x = ~date, y = ~uempmed, color = I("red"), showlegend = FALSE) \%>\% 
  add_lines() \%>\%
  add_markers(color = ~pop)

# a number of `add_*()` functions are special cases of the scatter trace
plot_ly(economics, x = ~date) \%>\% 
  add_ribbons(ymin = ~pce - 1e3, ymax = ~pce + 1e3)

# use `group_by()` (or `group2NA()`) to apply visual mapping
# once per group (e.g. one line per group)
txhousing \%>\% 
  group_by(city) \%>\% 
  plot_ly(x = ~date, y = ~median) \%>\%
  add_lines(color = I("black"))

\dontrun{
# use `add_sf()` or `add_polygons()` to create geo-spatial maps
# http://blog.cpsievert.me/2018/03/30/visualizing-geo-spatial-data-with-sf-and-plotly/
if (requireNamespace("sf", quietly = TRUE)) {
  nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)
  plot_ly() \%>\% add_sf(data = nc)
}

# univariate summary statistics
plot_ly(mtcars, x = ~factor(vs), y = ~mpg) \%>\% 
  add_boxplot()
plot_ly(mtcars, x = ~factor(vs), y = ~mpg) \%>\% 
  add_trace(type = "violin")
  
# `add_histogram()` does binning for you...
mtcars \%>\%
  plot_ly(x = ~factor(vs)) \%>\%
  add_histogram()
  
# ...but you can 'pre-compute' bar heights in R
mtcars \%>\%
  dplyr::count(vs) \%>\%
  plot_ly(x = ~vs, y = ~n) \%>\%
  add_bars()

# the 2d analogy of add_histogram() is add_histogram2d()/add_histogram2dcontour()
library(MASS)
(p <- plot_ly(geyser, x = ~waiting, y = ~duration))
add_histogram2d(p)
add_histogram2dcontour(p)

# the 2d analogy of add_bars() is add_heatmap()/add_contour()
# (i.e., bin counts must be pre-specified)
den <- kde2d(geyser$waiting, geyser$duration)
p <- plot_ly(x = den$x, y = den$y, z = den$z)
add_heatmap(p)
add_contour(p)

# `add_table()` makes it easy to map a data frame to the table trace type
plot_ly(economics) \%>\% 
  add_table()

# pie charts!
ds <- data.frame(labels = c("A", "B", "C"), values = c(10, 40, 60))
plot_ly(ds, labels = ~labels, values = ~values) \%>\%
  add_pie() \%>\%
  layout(title = "Basic Pie Chart using Plotly")
  
data(wind)
plot_ly(wind, r = ~r, theta = ~t) \%>\% 
  add_area(color = ~nms) \%>\%
  layout(
    polar = list(
      radialaxis = list(ticksuffix = "\%"), 
      angularaxis = list(rotation = 90)
    )
  )

# ------------------------------------------------------------
# 3D chart types
# ------------------------------------------------------------
plot_ly(z = ~volcano) \%>\% 
  add_surface()
plot_ly(x = c(0, 0, 1), y = c(0, 1, 0), z = c(0, 0, 0)) \%>\% 
  add_mesh()
}
\dontshow{\}) # examplesIf}
}
\references{
\url{https://plotly-r.com/overview.html}

\url{https://plotly.com/r/}

\url{https://plotly.com/r/reference/}
}
\seealso{
\code{\link[=plot_ly]{plot_ly()}}
}
\author{
Carson Sievert
}
