% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_moderators.R
\name{plot_moderator_d_linerange}
\alias{plot_moderator_d_linerange}
\title{Plot the posterior interval of the Conditional Average Treatment Effect grouped by a discrete variable}
\usage{
plot_moderator_d_linerange(.model, moderator, .alpha = 0.7, horizontal = FALSE)
}
\arguments{
\item{.model}{a model produced by `bartCause::bartc()`}

\item{moderator}{the moderator as a vector}

\item{.alpha}{transparency value [0, 1]}

\item{horizontal}{flip the plot horizontal?}
}
\value{
ggplot object
}
\description{
Plots the range of the Conditional Average Treatment Effect grouped by a discrete variable. This is analogous to plot_moderator_d_density but is preferable for moderators with many categories. Rather than plotting the full density, the posterior range is shown.
}
\examples{
\donttest{
data(lalonde)
confounders <- c('age', 'educ', 'black', 'hisp', 'married', 'nodegr')
model_results <- bartCause::bartc(
 response = lalonde[['re78']],
 treatment = lalonde[['treat']],
 confounders = as.matrix(lalonde[, confounders]),
 estimand = 'ate',
 commonSuprule = 'none'
)
plot_moderator_d_linerange(model_results, lalonde$educ)
}
}
\author{
George Perrett, Joseph Marlo
}
