# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sagemakeredgemanager_service.R
NULL

#' Use to get the active deployments from a device
#'
#' @description
#' Use to get the active deployments from a device.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakeredgemanager_get_deployments/](https://www.paws-r-sdk.com/docs/sagemakeredgemanager_get_deployments/) for full documentation.
#'
#' @param DeviceName &#91;required&#93; The unique name of the device you want to get the configuration of
#' active deployments from.
#' @param DeviceFleetName &#91;required&#93; The name of the fleet that the device belongs to.
#'
#' @keywords internal
#'
#' @rdname sagemakeredgemanager_get_deployments
sagemakeredgemanager_get_deployments <- function(DeviceName, DeviceFleetName) {
  op <- new_operation(
    name = "GetDeployments",
    http_method = "POST",
    http_path = "/GetDeployments",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemakeredgemanager$get_deployments_input(DeviceName = DeviceName, DeviceFleetName = DeviceFleetName)
  output <- .sagemakeredgemanager$get_deployments_output()
  config <- get_config()
  svc <- .sagemakeredgemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakeredgemanager$operations$get_deployments <- sagemakeredgemanager_get_deployments

#' Use to check if a device is registered with SageMaker Edge Manager
#'
#' @description
#' Use to check if a device is registered with SageMaker Edge Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakeredgemanager_get_device_registration/](https://www.paws-r-sdk.com/docs/sagemakeredgemanager_get_device_registration/) for full documentation.
#'
#' @param DeviceName &#91;required&#93; The unique name of the device you want to get the registration status
#' from.
#' @param DeviceFleetName &#91;required&#93; The name of the fleet that the device belongs to.
#'
#' @keywords internal
#'
#' @rdname sagemakeredgemanager_get_device_registration
sagemakeredgemanager_get_device_registration <- function(DeviceName, DeviceFleetName) {
  op <- new_operation(
    name = "GetDeviceRegistration",
    http_method = "POST",
    http_path = "/GetDeviceRegistration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemakeredgemanager$get_device_registration_input(DeviceName = DeviceName, DeviceFleetName = DeviceFleetName)
  output <- .sagemakeredgemanager$get_device_registration_output()
  config <- get_config()
  svc <- .sagemakeredgemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakeredgemanager$operations$get_device_registration <- sagemakeredgemanager_get_device_registration

#' Use to get the current status of devices registered on SageMaker Edge
#' Manager
#'
#' @description
#' Use to get the current status of devices registered on SageMaker Edge Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakeredgemanager_send_heartbeat/](https://www.paws-r-sdk.com/docs/sagemakeredgemanager_send_heartbeat/) for full documentation.
#'
#' @param AgentMetrics For internal use. Returns a list of SageMaker Edge Manager agent
#' operating metrics.
#' @param Models Returns a list of models deployed on the the device.
#' @param AgentVersion &#91;required&#93; Returns the version of the agent.
#' @param DeviceName &#91;required&#93; The unique name of the device.
#' @param DeviceFleetName &#91;required&#93; The name of the fleet that the device belongs to.
#' @param DeploymentResult Returns the result of a deployment on the device.
#'
#' @keywords internal
#'
#' @rdname sagemakeredgemanager_send_heartbeat
sagemakeredgemanager_send_heartbeat <- function(AgentMetrics = NULL, Models = NULL, AgentVersion, DeviceName, DeviceFleetName, DeploymentResult = NULL) {
  op <- new_operation(
    name = "SendHeartbeat",
    http_method = "POST",
    http_path = "/SendHeartbeat",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .sagemakeredgemanager$send_heartbeat_input(AgentMetrics = AgentMetrics, Models = Models, AgentVersion = AgentVersion, DeviceName = DeviceName, DeviceFleetName = DeviceFleetName, DeploymentResult = DeploymentResult)
  output <- .sagemakeredgemanager$send_heartbeat_output()
  config <- get_config()
  svc <- .sagemakeredgemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakeredgemanager$operations$send_heartbeat <- sagemakeredgemanager_send_heartbeat
