% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_inbound_integrations}
\alias{redshift_describe_inbound_integrations}
\title{Returns a list of inbound integrations}
\usage{
redshift_describe_inbound_integrations(
  IntegrationArn = NULL,
  TargetArn = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{IntegrationArn}{The Amazon Resource Name (ARN) of the inbound integration.}

\item{TargetArn}{The Amazon Resource Name (ARN) of the target of an inbound integration.}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.

Default: \code{100}

Constraints: minimum 20, maximum 100.}

\item{Marker}{An optional parameter that specifies the starting point to return a set
of response records. When the results of a
\code{\link[=redshift_describe_inbound_integrations]{describe_inbound_integrations}}
request exceed the value specified in \code{MaxRecords}, Amazon Web Services
returns a value in the \code{Marker} field of the response. You can retrieve
the next set of response records by providing the returned marker value
in the \code{Marker} parameter and retrying the request.}
}
\description{
Returns a list of inbound integrations.

See \url{https://www.paws-r-sdk.com/docs/redshift_describe_inbound_integrations/} for full documentation.
}
\keyword{internal}
