% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_failover_global_cluster}
\alias{docdb_failover_global_cluster}
\title{Promotes the specified secondary DB cluster to be the primary DB cluster
in the global cluster when failing over a global cluster occurs}
\usage{
docdb_failover_global_cluster(
  GlobalClusterIdentifier,
  TargetDbClusterIdentifier,
  AllowDataLoss = NULL,
  Switchover = NULL
)
}
\arguments{
\item{GlobalClusterIdentifier}{[required] The identifier of the Amazon DocumentDB global cluster to apply this
operation. The identifier is the unique key assigned by the user when
the cluster is created. In other words, it's the name of the global
cluster.

Constraints:
\itemize{
\item Must match the identifier of an existing global cluster.
\item Minimum length of 1. Maximum length of 255.
}

Pattern: \verb{[A-Za-z][0-9A-Za-z-:._]*}}

\item{TargetDbClusterIdentifier}{[required] The identifier of the secondary Amazon DocumentDB cluster that you want
to promote to the primary for the global cluster. Use the Amazon
Resource Name (ARN) for the identifier so that Amazon DocumentDB can
locate the cluster in its Amazon Web Services region.

Constraints:
\itemize{
\item Must match the identifier of an existing secondary cluster.
\item Minimum length of 1. Maximum length of 255.
}

Pattern: \verb{[A-Za-z][0-9A-Za-z-:._]*}}

\item{AllowDataLoss}{Specifies whether to allow data loss for this global cluster operation.
Allowing data loss triggers a global failover operation.

If you don't specify \code{AllowDataLoss}, the global cluster operation
defaults to a switchover.

Constraints:
\itemize{
\item Can't be specified together with the \code{Switchover} parameter.
}}

\item{Switchover}{Specifies whether to switch over this global database cluster.

Constraints:
\itemize{
\item Can't be specified together with the \code{AllowDataLoss} parameter.
}}
}
\description{
Promotes the specified secondary DB cluster to be the primary DB cluster in the global cluster when failing over a global cluster occurs.

See \url{https://www.paws-r-sdk.com/docs/docdb_failover_global_cluster/} for full documentation.
}
\keyword{internal}
