% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\alias{normalize.default}
\alias{normalize.numeric}
\alias{normalize.matrix}
\alias{normalize.data.frame}
\alias{normalize.list}
\title{Centering and scaling of numeric data}
\usage{
normalize(x, center = TRUE, scale = TRUE, ...)

\method{normalize}{default}(x, ...)

\method{normalize}{numeric}(x, center = TRUE, scale = TRUE, ...)

\method{normalize}{matrix}(
  x,
  center = TRUE,
  scale = TRUE,
  byrow = FALSE,
  ignore = integer(),
  jointly = list(),
  ...
)

\method{normalize}{data.frame}(
  x,
  center = TRUE,
  scale = TRUE,
  byrow = FALSE,
  ignore = integer(),
  jointly = list(),
  ...
)

\method{normalize}{list}(x, center = TRUE, scale = TRUE, ...)
}
\arguments{
\item{x}{An object to be normalized.}

\item{center}{[\code{logical(1)}]\cr
Normalize to zero mean?}

\item{scale}{[\code{logical(1)}]\cr
Normalize to unit variance?}

\item{...}{Further arguments to be passed to or from other methods.}

\item{byrow}{[\code{logical(1)}]\cr
Only relevant if \code{x} has two dimensions (rows and columns).

In this case, set to \code{TRUE} to normalize row-wise or \code{FALSE} to normalize
column-wise (default).}

\item{ignore}{[\code{integer()}]\cr
Column indices (or row indices if \code{byrow = TRUE}) to not normalize.}

\item{jointly}{[\code{list()}]\cr
Disjoint column indices (or row indices if \code{byrow = TRUE}) to normalize
jointly.}
}
\value{
The normalized input \code{x} with the centering and scaling values used (if any)
added as attributes \code{"center"} and \code{"scale"}.
}
\description{
Methods to normalize numeric data with respect to mean and variance.
}
\examples{
# can normalize numeric vectors, matrices, data.frames, and lists of those
normalize(
  list(
    c(-3, 0, 3),
    matrix(1:12, nrow = 3, ncol = 4),
    data.frame(a = 1:3, b = 4:6, c = 7:9, d = 10:12)
  )
)

# can ignore columns (or rows)
normalize(
  data.frame(a = 1:3, b = c("A", "B", "C"), c = 7:9, d = 10:12),
  ignore = 2
)

# can normalize columns (or rows) jointly
normalize(
  matrix(1:12, nrow = 3, ncol = 4),
  jointly = list(1:2, 3:4)
)
}
