% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.r
\name{plot_threshold}
\alias{plot_threshold}
\alias{plot_threshold.diffnet}
\alias{plot_threshold.array}
\alias{plot_threshold.default}
\title{Threshold levels through time}
\usage{
plot_threshold(graph, expo, ...)

\method{plot_threshold}{diffnet}(graph, expo, ...)

\method{plot_threshold}{array}(graph, expo, ...)

\method{plot_threshold}{default}(
  graph,
  expo,
  toa,
  include_censored = FALSE,
  t0 = min(toa, na.rm = TRUE),
  attrs = NULL,
  undirected = getOption("diffnet.undirected"),
  no.contemporary = TRUE,
  main = "Time of Adoption by\\nNetwork Threshold",
  xlab = "Time",
  ylab = "Threshold",
  vertex.size = "degree",
  vertex.color = NULL,
  vertex.label = "",
  vertex.label.pos = NULL,
  vertex.label.cex = 1,
  vertex.label.adj = c(0.5, 0.5),
  vertex.label.color = NULL,
  vertex.sides = 40L,
  vertex.rot = 0,
  edge.width = 2,
  edge.color = NULL,
  arrow.width = NULL,
  arrow.length = NULL,
  arrow.color = NULL,
  include.grid = FALSE,
  vertex.frame.color = NULL,
  bty = "n",
  jitter.factor = c(1, 1),
  jitter.amount = c(0.25, 0.025),
  xlim = NULL,
  ylim = NULL,
  edge.curved = NULL,
  background = NULL,
  ...
)
}
\arguments{
\item{graph}{A dynamic graph (see \code{\link{netdiffuseR-graphs}}).}

\item{expo}{\eqn{n\times T}{n * T} matrix. Esposure to the innovation obtained from \code{\link{exposure}}}

\item{...}{Additional arguments passed to \code{\link{plot}}.}

\item{toa}{Integer vector of length \eqn{n} with the times of adoption.}

\item{include_censored}{Logical scalar. Passed to \code{\link{threshold}}.}

\item{t0}{Integer scalar. Passed to \code{\link{threshold}}.}

\item{attrs}{Passed to \code{\link{exposure}} (via threshold).}

\item{undirected}{Logical scalar. When \code{TRUE} only the lower triangle of the adjacency matrix will considered (faster).}

\item{no.contemporary}{Logical scalar. When TRUE, edges for vertices with the same
\code{toa} won't be plotted.}

\item{main}{Character scalar. Title of the plot.}

\item{xlab}{Character scalar. x-axis label.}

\item{ylab}{Character scalar. y-axis label.}

\item{vertex.size}{Numeric vector of size \eqn{n}. Relative size of the vertices.}

\item{vertex.color}{Either a vector of size \eqn{n} or a scalar indicating colors of the vertices.}

\item{vertex.label}{Character vector of size \eqn{n}. Labels of the vertices.}

\item{vertex.label.pos}{Integer value to be passed to \code{\link{text}} via \code{pos}.}

\item{vertex.label.cex}{Either a numeric scalar or vector of size \eqn{n}. Passed to \code{text}.}

\item{vertex.label.adj}{Passed to \code{\link{text}}.}

\item{vertex.label.color}{Passed to \code{\link{text}}.}

\item{vertex.sides}{Either a vector of size \eqn{n} or a scalar indicating the
number of sides of each vertex (see details).}

\item{vertex.rot}{Either a vector of size \eqn{n} or a scalar indicating the
rotation in radians of each vertex (see details).}

\item{edge.width}{Numeric. Width of the edges.}

\item{edge.color}{Character. Color of the edges.}

\item{arrow.width}{Numeric value to be passed to \code{\link{arrows}}.}

\item{arrow.length}{Numeric value to be passed to \code{\link{arrows}}.}

\item{arrow.color}{Color.}

\item{include.grid}{Logical. When TRUE, the grid of the graph is drawn.}

\item{vertex.frame.color}{Either a vector of size \eqn{n} or a scalar indicating colors of vertices' borders.}

\item{bty}{See \code{\link{par}}.}

\item{jitter.factor}{Numeric vector of size 2 (for x and y) passed to \code{\link{jitter}}.}

\item{jitter.amount}{Numeric vector of size 2 (for x and y) passed to \code{\link{jitter}}.}

\item{xlim}{Passed to \code{\link{plot}}.}

\item{ylim}{Passed to \code{\link{plot}}.}

\item{edge.curved}{Logical scalar. When curved, generates curved edges.}

\item{background}{TBD}
}
\value{
Invisible. A data frame with the calculated coordinates, including:
`toa`, `threshold`, and `jit` (a jittered version of `toa`).
}
\description{
Draws a graph where the coordinates are given by time of adoption, x-axis,
and threshold level, y-axis.
}
\details{
When \code{vertex.label=NULL} the function uses vertices ids as labels.
By default \code{vertex.label=""} plots no labels.

Vertices are drawn using an internal function for generating polygons.
Polygons are inscribed in a circle of radius \code{vertex.size}, and can be
rotated using \code{vertex.rot}. The number of sides of each polygon
is set via \code{vertex.sides}.
}
\examples{

# Generating a random graph
set.seed(1234)
n <- 6
nper <- 5
graph <- rgraph_er(n,nper, p=.3, undirected = FALSE)
toa <- sample(2000:(2000+nper-1), n, TRUE)
adopt <- toa_mat(toa)

# Computing exposure
expos <- exposure(graph, adopt$cumadopt)

plot_threshold(graph, expos, toa)

# Calculating degree (for sizing the vertices)
plot_threshold(graph, expos, toa, vertex.size = "indegree")

}
\seealso{
Use \code{\link{threshold}} to retrieve the corresponding threshold
obtained returned by \code{\link{exposure}}.

Other visualizations: 
\code{\link{dgr}()},
\code{\link{diffusionMap}()},
\code{\link{drawColorKey}()},
\code{\link{grid_distribution}()},
\code{\link{hazard_rate}()},
\code{\link{plot_adopters}()},
\code{\link{plot_diffnet}()},
\code{\link{plot_diffnet2}()},
\code{\link{plot_infectsuscep}()},
\code{\link{rescale_vertex_igraph}()}
}
\author{
George G. Vega Yon
}
\concept{visualizations}
\keyword{hplot}
