% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-pipeline.R
\name{add_filters}
\alias{add_filters}
\title{Add filtering/exclusion criteria to a multiverse pipeline}
\usage{
add_filters(.df, ...)
}
\arguments{
\item{.df}{The original \code{data.frame}(e.g., base data set). If part of
set of add_* decision functions in a pipeline, the base data will be passed
along as an attribute.}

\item{...}{logical expressions to be used with \code{\link[dplyr]{filter}}
separated by commas. Expressions should not be quoted.}
}
\value{
a \code{data.frame} with three columns: type, group, and code. Type
indicates the decision type, group is a decision, and the code is the
actual code that will be executed. If part of a pipe, the current set of
decisions will be appended as new rows.
}
\description{
Add filtering/exclusion criteria to a multiverse pipeline
}
\examples{

library(tidyverse)
library(multitool)

# Simulate some data
the_data <-
  data.frame(
    id   = 1:500,
    iv1  = rnorm(500),
    iv2  = rnorm(500),
    iv3  = rnorm(500),
    mod1 = rnorm(500),
    mod2 = rnorm(500),
    mod3 = rnorm(500),
    cov1 = rnorm(500),
    cov2 = rnorm(500),
    dv1  = rnorm(500),
    dv2  = rnorm(500),
    include1 = rbinom(500, size = 1, prob = .1),
    include2 = sample(1:3, size = 500, replace = TRUE),
    include3 = rnorm(500)
  )

the_data |>
  add_filters(include1 == 0,include2 != 3,include2 != 2, include3 > -2.5)
}
