% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_dist.R
\name{k_dist}
\alias{k_dist}
\title{Distance at Cumulative Kernel Proportion}
\usage{
k_dist(
  sigma,
  prob = 0.95,
  kernel = c("gaussian", "exp", "expow", "fixed"),
  beta = NULL
)
}
\arguments{
\item{sigma}{Numeric. Scale parameter. For Gaussian and exponential, this is standard deviation or decay rate. For expow, this is the kernel bandwidth.}

\item{prob}{Numeric. Desired cumulative proportion (e.g., 0.95).}

\item{kernel}{Character. One of "gaussian", "exp", "expow", or "fixed".}

\item{beta}{Numeric. Shape parameter for exponential power kernel. Ignored unless kernel = "expow".}
}
\value{
Numeric. Distance at which the cumulative kernel density reaches the specified proportion.
}
\description{
Compute the distance at which a given cumulative density is reached for several kernel types.
}
\keyword{internal}
