% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_mlb.R
\name{scale_axes_mlb}
\alias{scale_x_mlb}
\alias{scale_y_mlb}
\title{Axis Scales for MLB Team Logos}
\usage{
scale_x_mlb(
  ...,
  expand = ggplot2::waiver(),
  guide = ggplot2::waiver(),
  position = "bottom",
  size = 12
)

scale_y_mlb(
  ...,
  expand = ggplot2::waiver(),
  guide = ggplot2::waiver(),
  position = "left",
  size = 12
)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{discrete_scale}}
  \describe{
    \item{\code{palette}}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the values that
they should take (e.g., \code{\link[scales:pal_hue]{scales::pal_hue()}}).}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} includes the levels in the factor. Please note that to display
every level in a legend, the layer should use \code{show.legend = TRUE}.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{na.value}}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
    \item{\code{aesthetics}}{The names of the aesthetics that this scale works with.}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{expand}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{position}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}

\item{size}{The logo size in pixels. It is applied as height for an x-scale
and as width for an y-scale.}
}
\value{
A discrete ggplot2 scale created with \code{\link[ggplot2:scale_discrete]{ggplot2::scale_x_discrete()}} or
\code{\link[ggplot2:scale_discrete]{ggplot2::scale_y_discrete()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}
\code{scale_x_mlb()} and \code{scale_y_mlb()} have been superceded in favor of \verb{element_*_logo()} functions
These functions map MLB team names to their team logos and make
them available as axis labels
}
\details{
The scale translates MLB team abbreviations into raw image
html and places the html as axis labels. Because of the way ggplots are
constructed, it is necessary to adjust the \code{\link[ggplot2:theme]{ggplot2::theme()}} after calling this
scale. This can be done by calling \code{\link[=theme_x_mlb]{theme_x_mlb()}} or \code{\link[=theme_y_mlb]{theme_y_mlb()}}
or alternatively by manually changing the relevant \code{axis.text} to
\code{\link[ggtext:element_markdown]{ggtext::element_markdown()}}. However, this will only work if an underlying
dependency, "gridtext", is installed with a newer version than 0.1.4
}
\examples{
\donttest{
library(mlbplotR)
library(ggplot2)

team_abbr <- valid_team_names()
# remove league logos from this example
team_abbr <- team_abbr[!team_abbr \%in\% c("AL", "NL", "MLB")]

df <- data.frame(
  random_value = runif(length(team_abbr), 0, 1),
  teams = team_abbr
)

if (utils::packageVersion("gridtext") > "0.1.4"){
  # use logos for x-axis
  ggplot(df, aes(x = teams, y = random_value)) +
    geom_col(aes(color = teams, fill = teams), width = 0.5) +
    scale_color_mlb(type = "secondary") +
    scale_fill_mlb(alpha = 0.4) +
    scale_x_mlb() +
    theme_minimal() +
    # theme_*_mlb requires gridtext version > 0.1.4
    theme_x_mlb()

  # use logos for y-axis
  ggplot(df, aes(y = teams, x = random_value)) +
    geom_col(aes(color = teams, fill = teams), width = 0.5) +
    scale_color_mlb(type = "secondary") +
    scale_fill_mlb(alpha = 0.4) +
    scale_y_mlb() +
    theme_minimal() +
    # theme_*_mlb requires gridtext version > 0.1.4
    theme_y_mlb()
}
}
}
