% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_missing_starts.R
\name{find_missing_starts}
\alias{find_missing_starts}
\title{Find start positions that cannot be found in \code{`data`}}
\usage{
find_missing_starts(data, n, starts_col = NULL, return_skip_numbers = TRUE)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.

\strong{N.B.} If \code{`data`} is a \emph{grouped} \code{data.frame},
the function is applied group-wise and the output is a
\code{list} of either \code{vector}s or \code{list}s.
The names are based on the group indices
(see \code{\link[dplyr:group_data]{dplyr::group_indices()}}).}

\item{n}{List of starting positions.

Skip values by \code{c(value, skip_to_number)} where \code{skip_to_number}
is the nth appearance of the value in the vector.

See \code{\link[groupdata2:group_factor]{group_factor()}} for explanations and
examples of using the \code{"l_starts"} method.}

\item{starts_col}{Name of column with values to match
when \code{`data`} is a \code{data.frame}. Pass \code{'index'} to use row names. (Character)}

\item{return_skip_numbers}{Return \code{skip-to-numbers} along with values (Logical).}
}
\value{
List of start values and \code{skip-to-numbers} or a \code{vector} with the start values.
Returns \code{NULL} if no values were found.

\strong{N.B.} If \code{`data`} is a \emph{grouped} \code{data.frame},
the function is applied group-wise and the output is a
\code{list} of either \code{vector}s or \code{list}s.
The names are based on the group indices
(see \code{\link[dplyr:group_data]{dplyr::group_indices()}}).
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("maturing")}

Tells you which values and (optionally) \code{skip-to-numbers} that are
recursively removed when using the \code{"l_starts"} method with \code{`remove_missing_starts`}
set to \code{TRUE}.
}
\examples{
# Attach packages
library(groupdata2)

# Create a data frame
df <- data.frame(
  "a" = c("a", "a", "b", "b", "c", "c"),
  stringsAsFactors = FALSE
)

# Create list of starts
starts <- c("a", "e", "b", "d", "c")

# Find missing starts with skip_to numbers
find_missing_starts(df, starts, starts_col = "a")

# Find missing starts without skip_to numbers
find_missing_starts(df, starts,
  starts_col = "a",
  return_skip_numbers = FALSE
)
}
\seealso{
Other l_starts tools: 
\code{\link{differs_from_previous}()},
\code{\link{find_starts}()},
\code{\link{group}()},
\code{\link{group_factor}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{l_starts tools}
