% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-issue.R
\name{create_issue}
\alias{create_issue}
\title{Create a new issue}
\usage{
create_issue(base_url, api_key, owner, repo, title, body)
}
\arguments{
\item{base_url}{URL prefix for your gitea server (no trailing '/')}

\item{api_key}{The user's API token key for the gitea service}

\item{owner}{The owner of the repository}

\item{repo}{The name of the repository}

\item{title}{The title of the issue}

\item{body}{The body text of the issue}
}
\value{
list with results of the new issue
}
\description{
Create an new issue in a specific repository
}
\examples{
\dontrun{
create_issue(base_url = "https://example.gitea.service.com",
             api_key = "ccaf5c9a22e854856d0c5b1b96c81e851bafb288",
             owner = "company",
             repo = "test_repo",
             title = "Perform clean code task",
             body = "Perform in an orderly manner and document steps")
}
}
