% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRR_BaseRFxns.R
\name{find_fiducial_interval_R}
\alias{find_fiducial_interval_R}
\title{Fiducial interval logic in base R, for randomization test}
\usage{
find_fiducial_interval_R(
  obsW,
  obsY,
  allW,
  tau_obs,
  alpha = 0.05,
  c_initial = 2,
  n_search_attempts = 500
)
}
\arguments{
\item{obsW}{Observed assignment (0/1).}

\item{obsY}{Observed outcome.}

\item{allW}{Matrix of candidate random assignments (rows = assignments).}

\item{tau_obs}{Observed difference in means with obsW, obsY.}

\item{alpha}{Significance level (default 0.05).}

\item{c_initial}{A numeric step scale (default 2).}

\item{n_search_attempts}{Number of bracket search attempts (default 500).}
}
\value{
2-element numeric vector [lower, upper] or [NA, NA] if none accepted.
}
\description{
Fiducial interval logic in base R, for randomization test
}
