% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLARMA.R
\name{GLARMA}
\alias{GLARMA}
\title{Estimate a GLARMA model}
\usage{
GLARMA(
  formula,
  ic = c("aic", "bic"),
  distr = c("Poi", "NegBin"),
  method = c("FS", "NR"),
  residuals = c("Pearson", "Score"),
  trace = FALSE
)
}
\arguments{
\item{formula}{Model specification (see "Specials" section).}

\item{ic}{Character, can be 'AIC','BIC'. The information criterion used in selecting the model.}

\item{distr}{Character, can be 'poisson' or 'nbinom'. The probabilty distribution used for the generalized model}

\item{method}{Character, can be 'FS' (Fisher scoring) or 'NR' (Newton-Raphson). The method of iteration to be used}

\item{residuals}{Character, can be 'Pearson' or 'Score'. The type of residuals to be used}

\item{trace}{Logical. If the automatic parameter algorithm is runnig, print the path to the best model estimation}
}
\value{
A model specification.
}
\description{
Estimate Generalized Linear Autoregressive Moving Average  model
with Poisson or Negative Binomial distribution.
Also is provide a automatic parameter algorithm selection for the Autorregressive and Moving Average params
}
\section{Specials}{


\subsection{pq}{
pq defines the non-seasonal autoregressive and moving avarages terms,
it can be define by the user,
or if it's omited, the automatic parameter selection algorithm is trigered
The automatic parameter selection algorithm gonna fit the best model based on the information criterion
}

\subsection{PQ}{
PQ defines the seasonal autoregressive and moving avarages terms,
it can be define by the user,
or if it's omited, the automatic parameter selection algorithm is trigered (only for 'arma_to_GLARMA' algorithm)
The automatic parameter selection algorithm gonna fit the best model based on the information criterion
}

\subsection{xreg}{
Exogenous regressors can be included in an GLARMA model without explicitly using the `xreg()` special.
Common exogenous regressor specials as specified in [`common_xregs`] can also be used.
These regressors are handled using [stats::model.frame()],
and so interactions and other functionality behaves similarly to [stats::lm()].

The inclusion of a constant in the model follows the similar rules to [`stats::lm()`],
where including `1` will add a constant and `0` or `-1` will remove the constant.
If left out, the inclusion of a constant will be determined by minimising `ic`.

If a xreg is provided, the model forecast is not avaliable

\preformatted{
xreg(..., fixed = list())
}

\tabular{ll}{
  `...`      \tab Bare expressions for the exogenous regressors (such as `log(x)`)\cr
  `fixed`    \tab A named list of fixed parameters for coefficients. The names identify the coefficient, and should match the name of the regressor. For example, `fixed = list(constant = 20)`.
}
}
}

\examples{
# Manual GLARMA specification
tsibbledata::aus_production |>
  fabletools::model(manual_gla = GLARMA(Beer ~ pq(1,0)))

# Automatic GLARMA specification
tsibbledata::aus_production |>
  fabletools::model(auto_gla = GLARMA(Beer, ic = 'aic'))


}
