% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_status}
\alias{send_status}
\title{Send a WhatsApp Status (story)}
\usage{
send_status(
  client,
  type = c("text", "image", "video", "document", "audio"),
  content,
  caption = NULL,
  background_color = NULL,
  font = NULL,
  all_contacts = FALSE,
  status_jid_list = NULL,
  verbose = FALSE
)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{type}{One of \code{"text"}, \code{"image"}, \code{"video"}, \code{"document"}, \code{"audio"}.}

\item{content}{Text (for \code{type = "text"}) or URL/base64 for media.}

\item{caption}{Optional caption for media.}

\item{background_color}{Hex color for text status background.}

\item{font}{Integer font id.}

\item{all_contacts}{Logical. Send to all contacts.}

\item{status_jid_list}{Optional character vector of JIDs.}

\item{verbose}{Logical. If TRUE, logs request/response details.}
}
\value{
A named list parsed from the JSON response returned by Evolution API.
The object contains fields such as \code{status}, \code{message}, \code{queueId}, or
other elements depending on the API endpoint.
The HTTP status code of the request is stored in \code{attr(result, "http_status")}.
This output represents the API-level confirmation of the status message sent.
}
\description{
Send a WhatsApp Status (story)
}
