% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{PosteriorFunction}
\alias{PosteriorFunction}
\title{Generate the posterior function of the Dirichlet function}
\usage{
PosteriorFunction(dpobj, ind)
}
\arguments{
\item{dpobj}{Fitted Dirichlet Process object}

\item{ind}{What iteration to draw the posterior function from. Defaults to the last iteration.}
}
\value{
A posterior function f(x).
}
\description{
Generate the posterior function of the Dirichlet function
}
\examples{

y <- rnorm(10)
dp <- DirichletProcessGaussian(y)
dp <- Fit(dp, 5)
postFuncDraw <- PosteriorFunction(dp)
plot(-3:3, postFuncDraw(-3:3))

}
