% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirichlet_process_weibull.R
\name{DirichletProcessWeibull}
\alias{DirichletProcessWeibull}
\title{Create a Dirichlet Mixture of the Weibull distribution}
\usage{
DirichletProcessWeibull(
  y,
  g0Priors,
  alphaPriors = c(2, 4),
  mhStepSize = c(1, 1),
  hyperPriorParameters = c(6, 2, 1, 0.5),
  verbose = FALSE,
  mhDraws = 250
)
}
\arguments{
\item{y}{Data.}

\item{g0Priors}{Base Distribution Priors.}

\item{alphaPriors}{Prior for the concentration parameter.}

\item{mhStepSize}{Step size for the new parameter in the Metropolis Hastings algorithm.}

\item{hyperPriorParameters}{Hyper prior parameters.}

\item{verbose}{Set the level of screen output.}

\item{mhDraws}{Number of Metropolis-Hastings samples to perform for each cluster update.}
}
\value{
Dirichlet process object
}
\description{
The likelihood is parameterised as \eqn{\mathrm{Weibull} (y | a, b) = \frac{a}{b} y ^{a-1}  \exp \left( -  \frac{x^a}{b}  \right)}.
The base measure is a Uniform Inverse Gamma Distribution.
\eqn{G_0 (a, b | \phi, \alpha _0 , \beta _0) = U(a | 0, \phi ) \mathrm{Inv-Gamma} ( b | \alpha _0, \beta _0)}
\eqn{\phi \sim \mathrm{Pareto}(x_m , k)}
\eqn{\beta \sim \mathrm{Gamma} (\alpha _0 , \beta _0)}
This is a semi-conjugate distribution. The cluster parameter a is updated using the Metropolis Hastings algorithm an analytical posterior exists for b.
}
\references{
Kottas, A. (2006). Nonparametric Bayesian survival analysis using mixtures of Weibull distributions. Journal of Statistical Planning and Inference, 136(3), 578-596.
}
