% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_asv_matrix.R
\name{convert_asv_matrix_to_objs}
\alias{convert_asv_matrix_to_objs}
\title{Filter ASV abundance matrix and convert to 'taxmap' and 'phyloseq' objects}
\usage{
convert_asv_matrix_to_objs(
  analysis_setup,
  min_read_depth = 0,
  minimum_bootstrap = 0,
  save_outputs = FALSE
)
}
\arguments{
\item{analysis_setup}{An object containing directory paths and
data tables, produced by the \code{prepare_reads} function}

\item{min_read_depth}{ASV filter parameter. If mean read depth of across all
samples is less than this threshold, ASV will be filtered.}

\item{minimum_bootstrap}{Set threshold for bootstrap support value for taxonomic
assignments. Below designated minimum bootstrap threshold, taxonomic
assignments will be set to N/A}

\item{save_outputs}{Logical, indicating whether to save the resulting phyloseq
and 'taxmap' objects. If TRUE, the objects will be saved; if FALSE, they will
only be available in the global environment. Default is FALSE.}
}
\value{
ASV matrix converted to 'taxmap' object
}
\description{
Filter ASV abundance matrix and convert to 'taxmap' and 'phyloseq' objects
}
\examples{
\donttest{
# Convert final matrix to 'taxmap' and phyloseq objects for downstream analysis steps
analysis_setup <- prepare_reads(
data_directory = system.file("extdata", package = "demulticoder"),
  output_directory = tempdir(),
  overwrite_existing = TRUE
)
cut_trim(
analysis_setup,
cutadapt_path="/usr/bin/cutadapt",
overwrite_existing = TRUE
)
make_asv_abund_matrix(
analysis_setup,
overwrite_existing = TRUE
)
assign_tax(
analysis_setup,
asv_abund_matrix,
retrieve_files=FALSE,
overwrite_existing=TRUE
)
objs<-convert_asv_matrix_to_objs(
analysis_setup
)
}
}
