% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heart_fill.R
\name{heart_fill}
\alias{heart_fill}
\title{Visualize a Heart Filling with Color using D3}
\usage{
heart_fill(
  fill_level = 0.65,
  heartSize = 150,
  strokeColor = "#C00",
  strokeWidth = 4,
  fillColor = "red",
  renderFillLabel = TRUE,
  labelColor = "#333",
  labelFontSize = "16px",
  titleText = "Fill level",
  titleColor = "#333",
  titleFontSize = "14px",
  font = "Verdana, Geneva, Tahoma, sans-serif"
)
}
\arguments{
\item{fill_level}{Value between 0 and 1 indicating how full the heart should appear (e.g., 0.65).}

\item{heartSize}{Width/height scale of the heart in pixels.}

\item{strokeColor}{Color of the heart outline.}

\item{strokeWidth}{Width of the heart outline stroke.}

\item{fillColor}{Color used to fill the heart based on the fill level.}

\item{renderFillLabel}{Whether to display a percentage label above the heart.}

\item{labelColor}{Color of the percentage label text.}

\item{labelFontSize}{Font size of the percentage label text (e.g., "16px").}

\item{titleText}{Optional title displayed below the heart.}

\item{titleColor}{Color of the title text.}

\item{titleFontSize}{Font size of the title text (e.g., "14px").}

\item{font}{Font family used for text labels and title.}
}
\value{
An interactive D3 heart fill visualization rendered in the RStudio Viewer or web browser.
}
\description{
This function renders a heart-shaped SVG graphic that fills from the bottom up based on the provided level.
The appearance of the heart and the optional label can be fully customized. It uses the `r2d3` package to
render the visualization with D3.js.
}
\examples{
heart_fill(fill_level = 0.9)
heart_fill(
  fill_level = 0.4,
  fillColor = "pink",
  labelColor = "#C00",
  strokeColor = "#900"
)

}
