% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R, R/parClass.R
\name{parframe}
\alias{parframe}
\alias{is.parframe}
\alias{[.parframe}
\alias{subset.parframe}
\title{Generate a parameter frame}
\usage{
parframe(
  x = NULL,
  parameters = colnames(x),
  metanames = NULL,
  obj.attributes = NULL
)

is.parframe(x)

\method{[}{parframe}(x, i = NULL, j = NULL, drop = FALSE)

\method{subset}{parframe}(x, ...)
}
\arguments{
\item{x}{data.frame.}

\item{parameters}{character vector, the names of the parameter columns.}

\item{metanames}{character vector, the names of the meta-information columns.}

\item{obj.attributes}{character vector, the names of the objective function attributes.}

\item{i}{row index in any format}

\item{j}{column index in any format}

\item{drop}{logical. If TRUE the result is coerced to the lowest possible dimension}

\item{...}{additional arguments}
}
\value{
An object of class \code{parframe}, i.e. a data.frame with attributes for the
different names. Inherits from data.frame.
}
\description{
A parameter frame is a data.frame where the rows correspond to different
parameter specifications. The columns are divided into three parts. (1) the meta-information
columns (e.g. index, value, constraint, etc.), (2) the attributes of an objective function
(e.g. data contribution and prior contribution) and (3) the parameters.
}
\details{
Parameter frames can be subsetted either by \code{[ , ]} or by \code{subset}. If
\code{[ , index]} is used, the names of the removed columns will also be removed from
the corresponding attributes, i.e. metanames, obj.attributes and parameters.
}
\examples{
## Generate a prediction function
regfn <- c(y = "sin(a*time)")

g <- Y(regfn, parameters = "a")
x <- Xt(condition = "C1")

## Generate data
data <- datalist(
  C1 = data.frame(
    name = "y",
    time = 1:5,
    value = sin(1:5) + rnorm(5, 0, .1),
    sigma = .1
  )
)

## Initialize parameters and time 
pars <- c(a = 1)
times <- seq(0, 5, .1)

plot((g*x)(times, pars), data)

## Do many fits from random positions and store them into parlist
out <- as.parlist(lapply(1:50, function(i) {
  trust(normL2(data, g*x), pars + rnorm(length(pars), 0, 1), rinit = 1, rmax = 10)
}))

summary(out)

## Reduce parlist to parframe
parframe <- as.parframe(out)
plotValues(parframe)

## Reduce parframe to best fit
bestfit <- as.parvec(parframe)
plot((g*x)(times, bestfit), data)


}
\seealso{
\link{profile}, \link{mstrust}
}
