% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_equal.R
\name{all_equal}
\alias{all_equal}
\title{Are all values of x nearly equal (within a tolerance) to all values of y?}
\usage{
all_equal(x, y, tol = get_tolerance(), na.rm = FALSE)
}
\arguments{
\item{x}{A \link{double} vector.}

\item{y}{A \link{double} vector.}

\item{tol}{A \link{double} vector of tolerances.}

\item{na.rm}{Should \code{NA} values be ignored? Default is \code{FALSE}.}
}
\value{
A logical vector of length 1.

The result should match \code{all(double_equal(x, y))}, including the way
\code{NA} values are handled.
}
\description{
A memory-efficient alternative to \code{all.equal.numeric()}.
}
\details{
\code{all_equal} compares each pair of
double-precision floating point numbers
in the same way as \code{double_equal}.
If any numbers differ, the algorithm breaks immediately,
which can offer significant speed when there are differences at
the start of a vector.
All arguments are recycled except \code{na.rm}.
}
\examples{
library(cppdoubles)
library(bench)
x <- seq(0, 1, 0.2)
y <- sqrt(x)^2

all_equal(x, y)

# Comparison to all.equal
z <- runif(10^4, 1, 100)
ones <- rep(1, length(z))
mark(base = isTRUE(all.equal(z, z)),
            cppdoubles = all_equal(z, z),
            iterations = 100)
mark(base = isTRUE(all.equal(z, ones)),
            cppdoubles = all_equal(z, ones),
            iterations = 100)

}
