% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LGDat.R
\docType{data}
\name{LGDat}
\alias{LGDat}
\title{Legendre and Gallagher Synthetic Example}
\format{
A 19 rows by 10 columns \code{\link{data.frame}}.
}
\source{
Legendre, P. & Gallagher E. D. 2001. Ecologically meaningful
transformations for ordination of species data. Oecologia 129: 271-280
doi: 10.1007/s004420100716
}
\usage{
data(LGDat)
}
\description{
A data set used as a synthetic example in paper Legendre and Gallagher
(2001).
}
\details{
This synthetic data set is described by Legendre and Gallagher
(2001) and was used to test species abundance transformations. Its first
column contains geographic locations from 1 to 19 (no particular units are
specified). The five columns that follow contain abundances of five species
with abundances peaking at 7-8 at different locations (site 1, 5, 10, 15, and
19). The latter are considered "abundant species". For next four columns
contains abundances of "rare species" occurring in between the abundance
species (abundances from 1 to 4).
}
\examples{
data(LGDat)
summary(LGDat)

}
