if(!file.exists("../windows/grpc/include/grpc/grpc.h")){
  unlink("../windows", recursive = TRUE)
  url <- if(grepl("aarch", R.version$platform)){
    "https://github.com/r-windows/bundles/releases/download/grpc-1.51.1/grpc-1.51.1-clang-aarch64.tar.xz"
  } else if(grepl("clang", Sys.getenv('R_COMPILED_BY'))){
    "https://github.com/r-windows/bundles/releases/download/grpc-1.51.1/grpc-1.51.1-clang-x86_64.tar.xz"
  } else {
    "https://github.com/rwinlib/grpc/archive/refs/tags/1.33.2-2.tar.gz"
  }
  download.file(url, basename(url), quiet = TRUE)
  dir.create("../windows", showWarnings = FALSE)
  untar(basename(url), exdir = "../windows", tar = 'internal')
  unlink(basename(url))
  oldwd <- setwd("../windows")
  on.exit(setwd(oldwd), add = TRUE)
  file.rename(list.files(), 'grpc')
}