% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{geo_world0}
\alias{geo_world0}
\alias{geotransform_to_world}
\title{World file parameter creator}
\usage{
geo_world0(px, ul, sh = c(0, 0))

geotransform_to_world(x)
}
\arguments{
\item{px}{pixel resolution (XY, Y-negative)}

\item{ul}{grid offset, top-left corner}

\item{sh}{affine shear (XY)}

\item{x}{geotransform parameters, as per \code{\link[=geo_transform0]{geo_transform0()}}}
}
\value{
vector of parameters xres, yskew, xskew, yres, xmin, ymax

world vector, as per \code{\link[=geo_world0]{geo_world0()}}
}
\description{
Basic function to create a \href{https://en.wikipedia.org/wiki/World_file}{'world file'}
as used by various non-geo image formats

Reformat to world vector.
}
\details{
Note that xmin/xmax are \emph{centre_of_cell} (of top-left cell) unlike the geotransform which is
top-left \emph{corner_of_cell}. The parameters are otherwise the same, but in a different order.
}
\examples{
geo_world0(px = c(1, -1), ul = c(0, 0))
(gt <- geo_transform0(px = c(1, -1), ul = c(0, 0)))
wf <- geotransform_to_world(gt)
world_to_geotransform(wf)
}
\seealso{
\link{geo_transform0}
}
