% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_length.R
\name{MorphyTreeLength}
\alias{MorphyTreeLength}
\alias{MorphyLength}
\alias{GetMorphyLength}
\alias{C_MorphyLength}
\title{Calculate parsimony score from Morphy object}
\usage{
MorphyTreeLength(tree, morphyObj)

MorphyLength(
  parent,
  child,
  morphyObj,
  inPostorder = FALSE,
  nTaxa = mpl_get_numtaxa(morphyObj)
)

GetMorphyLength(parentOf, leftChild, rightChild, morphyObj)

C_MorphyLength(parentOf, leftChild, rightChild, morphyObj)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}, with tip
labels in the order generated by \code{\link[TreeTools]{RenumberTips}},
i.e. corresponding to the sequence of taxa in the corresponding Morphy object.}

\item{morphyObj}{Object of class \code{morphy}, perhaps created with
\code{\link[=PhyDat2Morphy]{PhyDat2Morphy()}}.}

\item{parent}{Integer vector corresponding to the first column of the edge
matrix of a tree of class \code{\link[ape]{phylo}}, i.e.
\code{tree[["edge"]][, 1]}}

\item{child}{Integer vector corresponding to the second column of the edge
matrix of a tree of class \code{\link[ape]{phylo}}, i.e.
\code{tree[["edge"]][, 2]}.}

\item{parentOf}{For each node, numbered in postorder, the number of its parent node.}

\item{leftChild}{For each internal node, numbered in postorder, the number of its left
child node or tip.}

\item{rightChild}{For each internal node, numbered in postorder, the number of its right
child node or tip.}
}
\value{
\code{MorphyTreeLength()} returns the length of the tree,
after applying weighting.
}
\description{
This function must be passed a valid Morphy object, or R may crash.
For most users, the function \code{\link[=TreeLength]{TreeLength()}} will be more appropriate.
}
\section{Functions}{
\itemize{
\item \code{MorphyLength()}: Faster function that requires internal tree
parameters. Node numbering must increase monotonically away from root.

\item \code{GetMorphyLength()}: Fastest function that requires internal tree parameters

\item \code{C_MorphyLength()}: Direct call to C function. Use with caution.

}}
\seealso{
PhyDat2Morphy

Other tree scoring: 
\code{\link{CharacterLength}()},
\code{\link{IWScore}()},
\code{\link{LengthAdded}()},
\code{\link{MinimumLength}()},
\code{\link{TaxonInfluence}()}

Other tree scoring: 
\code{\link{CharacterLength}()},
\code{\link{IWScore}()},
\code{\link{LengthAdded}()},
\code{\link{MinimumLength}()},
\code{\link{TaxonInfluence}()}
}
\author{
Martin R. Smith
}
\concept{tree scoring}
\keyword{internal}
