% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginalvector.R
\name{marginalvector}
\alias{marginalvector}
\title{Marginal contributions vector}
\usage{
marginalvector(v, binary = FALSE, permutation)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{permutation}{Position of the permutation in the Lehmer code order, as an integer.}
}
\value{
The vector of marginal contributions.
}
\description{
Given a game and a permutation, this function returns the corresponding marginal contributions vector.
}
\details{
Given a game \eqn{v\in G^N} and an order \eqn{\pi} of the players in \eqn{N},
the marginal contributions associated with order \eqn{\pi} is defined, for all \eqn{i \in N}, as
\eqn{m_i^{\pi}=v(Pre^{\pi}(i)\cap i)-v(Pre^{\pi}(i))}, being \eqn{Pre^{\pi}(i)=\{j:\pi(j)<\pi(i)\}}.
}
\examples{
n <- 3
v <- c(1, 5, 10, 30, 60, 90, 200)
for (i in 1:factorial(n)) {
  cat("[", i, "]", paste(getpermutation(3,i)),"  ",
  paste(marginalvector(v,binary=FALSE,i)), "\n")
}
}
\seealso{
\link{getpermutation}, \link{getpermutationnumber}
}
