% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lorenzdominancerelation.R
\name{lorenzdominancerelation}
\alias{lorenzdominancerelation}
\title{Lorenz dominance relation}
\usage{
lorenzdominancerelation(x, y)
}
\arguments{
\item{x}{A vector.}

\item{y}{A vector.}
}
\value{
There are four possible outputs:

\item{-1}{if the introduced vectors are not Lorenz-comparable.}

\item{0}{if the vectors are Lorenz-equal.}

\item{1}{if the vectors are not Lorenz-equal and the first one Lorenz-dominates the second one.}

\item{2}{if the vectors are not Lorenz-equal and the second one Lorenz-dominates the first one.}
}
\description{
Given two awards vectors, this function returns the Lorenz dominance relation between them.
}
\details{
In order to compare two vectors \eqn{x,y\in \mathbb{R}^n} through the Lorenz criterion,
both of them must be rearranged in non-decreasing order; thus, let \eqn{\bar{x}} and \eqn{\bar{y}}
be the vectors obtained by rearranging \eqn{x} and \eqn{y}, respectively, in non-decreasing order.
It is said that \eqn{x} Lorenz-dominates \eqn{y} (or that \eqn{y} is Lorenz-dominated by \eqn{x})
if all the cumulative sums of \eqn{\bar{x}} are not less than those of \eqn{\bar{y}}.
That is, \eqn{x} Lorenz-dominates \eqn{y} if \eqn{\sum_{j=1}^{n}\bar{x}_j=\sum_{j=1}^{n}\bar{y}_j}
and, for each \eqn{k=1,\dots,n-1}, \deqn{\sum_{j=1}^{k}\bar{x}_j \geq \sum_{j=1}^{k}\bar{y}_j.}

If \eqn{x} Lorenz-dominates \eqn{y} and \eqn{y} Lorenz-dominates \eqn{x},
then \eqn{x} and \eqn{y} are said to be Lorenz-equal.

If \eqn{x} does not Lorenz-dominate \eqn{y} and \eqn{y} does not Lorenz-dominate \eqn{x},
then \eqn{x} and \eqn{y} are not Lorenz-comparable.
}
\examples{
lorenzdominancerelation(c(1,2,3), c(1,1,4))
lorenzdominancerelation(c(1,2,7,2), c(1,1,4,6))
}
\references{
Lorenz, M. O. (1905). Methods of Measuring the Concentration of Wealth. \emph{Publications of the American Statistical Association}, 9(70), 209-219.
}
