% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kohlbergcriterion.R
\name{kohlbergcriterion}
\alias{kohlbergcriterion}
\title{Kohlberg criterion for the prenucleolus}
\usage{
kohlbergcriterion(v, x, binary = FALSE, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{x}{An efficient allocation, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{tol}{A tolerance parameter, as a non-negative number.\cr
By default, \code{tol=100*.Machine$double.eps}.}
}
\value{
\code{TRUE} if \code{x} is the prenucleolus of \code{v}, \code{FALSE} otherwise.
}
\description{
This function applies the Kohlberg criterion to check if the given efficient allocation is the prenucleolus of the given game.
}
\details{
Given \eqn{v \in G^{N}} and \eqn{x \in \mathbb{R}^{n}} with \eqn{\sum_{i \in N} x_{i} = v(N)},
let \eqn{k(x)} be the number of different excesses in \eqn{x}.
According to the Kohlberg criterion for the prenucleolus, \eqn{x} is the prenucleolus of \eqn{v}
if and only if, for each \eqn{j \in \{1,\dots,k(x)\}}, \eqn{\bigcup_{t=1}^{j} F^{t}}
is a balanced family, being \eqn{F^{t}} the set of coalitions associated with the excess
that occupies position \eqn{t} when excesses are arranged in decreasing order.
}
\examples{
v <- c(0,0,0,0,10,40,30,60,10,20,90,90,90,130,160)
x <- prenucleolusvalue(v)
kohlbergcriterion(v, x) # x is the prenucleolus of v
y <- prenucleolusvalue(v) + c(1,-1,0,0)
kohlbergcriterion(v, y) # y is not the prenucleolus of v

# If the game is 0-monotonic, its nucleolus coincides with its prenucleolus,
# and therefore must pass the Kohlberg criterion for the prenucleolus:
v4 <- c(-2,-2,-2,7,7,7,6)
zeromonotoniccheck(v4)
kohlbergcriterion(v4, nucleolusvalue(v4))
}
\references{
Kohlberg, E. (1971). On the Nucleolus of a Characteristic Function Game. \emph{SIAM Journal on Applied Mathematics}, 20(1), 62–66.
}
\seealso{
\link{balancedfamilycheck}, \link{excesses}, \link{prenucleolusvalue}
}
