% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excesses.R
\name{excesses}
\alias{excesses}
\title{Coalition excesses}
\usage{
excesses(v, binary = FALSE, x)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{x}{An allocation, as a vector.}
}
\value{
The excesses of all coalitions, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
Given a game and an allocation, this function computes the excess of each coalition.
}
\details{
Given a game \eqn{v\in G^N} and an allocation \eqn{x}, the excess of coalition \eqn{S \in 2^N}
with respect to \eqn{x} is defined as \eqn{e(x,S)=v(S)-x(S)}, where \eqn{x(S)=\sum_{i\in S} x_i}.
}
\examples{
excesses(v=c(0,0,3,0,3,8,6,0,6,9,15,8,16,17,20), binary=TRUE, x=c(8,7,2,3))
excesses(v=c(1,5,10,6,11,15,16), x=c(1,5,10)) <= 0 # core allocation
}
\seealso{
\link{nucleolusvalue}, \link{nucleoluspcvalue}
}
