% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebin2lex.R
\name{codebin2lex}
\alias{codebin2lex}
\title{Binary order position to lexicographic order position}
\usage{
codebin2lex(n, Nbin)
}
\arguments{
\item{n}{Number of players, as an integer.}

\item{Nbin}{A binary order position, as an integer between 1 and \eqn{2^{\code{n}}-1}.}
}
\value{
The corresponding lexicographic order position, as an integer between 1 and \eqn{2^{\code{n}}-1}.
}
\description{
Given the binary order position of a coalition, this function returns the corresponding lexicographic order position.
}
\details{
The binary order position of a coalition \eqn{S\in 2^N} is given by \eqn{\sum_{i\in S} 2^{i-1}}. Lexicographic order arranges coalitions in ascending order according to size, and applies lexicographic order to break ties among coalitions of the same size.
}
\examples{
codebin2lex(5, 4)
}
\seealso{
\link{bin2lex}, \link{codelex2bin}, \link{lex2bin}
}
