% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/claimsgame.R
\name{claimsgame}
\alias{claimsgame}
\title{Pessimistic claims game associated with a claims problem}
\usage{
claimsgame(E, d, binary = FALSE)
}
\arguments{
\item{E}{An endowment, as a positive number.}

\item{d}{A vector of claims.}

\item{binary}{A logical value. By default, \code{binary=FALSE}.}
}
\value{
The characteristic function of the pessimistic claims game, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
Given a claims problem, this function returns the associated pessimistic claims game.
}
\details{
A claims problem is a triple \eqn{(N,E,d)} where \eqn{E\ge 0} is an amount to be distributed among a set \eqn{N} of agents and \eqn{d\in \mathbb{R}^{|N|}} is a vector of claims satisfying \eqn{\sum_{i=1}^{n} d_i\ge E}.

Given a claims problem \eqn{(N,E,d)}, its associated claims game, \eqn{v_{E,d}\in G^N}, is defined by
\deqn{v_{E,d}(S)=\max\{0, \; E-\sum_{i\in N\backslash S}d_i\}\text{ for all }S\in 2^N.}

For further analysis and computational methods related to conflicting claims problems,
see the \pkg{ClaimsProblems} package \cite{Sánchez Rodríguez et al. (2025)}.
}
\examples{
E <- 10
d <- c(2,4,7,8)
claimsgame(E,d)
}
\references{
O’Neill, B. (1982). A problem of rights arbitration from the Talmud. \emph{Mathematical Social Sciences}, 2, 345–371.

Sánchez Rodríguez, E., Núñez Lugilde, I., Mirás Calvo, M., & Quinteiro Sandomingo, C. (2025). \emph{ClaimsProblems: Analysis of Conflicting Claims}. R package version 1.0.0.

            \url{https://CRAN.R-project.org/package=ClaimsProblems}
}
\seealso{
\link{airfieldgame}
}
