graphcomponents <- function(Players, G) {
  # GraphComponents Connected components of a graph
  # Introducimos los arcos con una matriz
  # G <- matrix(c(1, 2, 2, 3,4, 5), ncol = 2, byrow = TRUE)
  # graphcomponents(c(1,2,3,4),G)

  # Arreglos en la matriz del grafo
  # Ordenamos los pares y eliminamos repetidos
  G <- G[order(G[, 1], G[, 2]), ]
  G <- unique(G)

  # Jugadores sin visitar
  Psin <- Players

  # Arcos sin visitar
  Gsin <- matrix(as.vector(t(G)),ncol=2,byrow=TRUE)

  # Número de componentes conexas
  numC <- 1

  # Lista para almacenar las componentes conexas
  componentes <- list()

  # Mientras haya jugadores sin visitar, seguimos calculando componente conexa
  while (length(Psin) > 0) {
    if (length(Gsin) == 0) {
      # Si no hay arcos sin visitar, cada jugador restante es una componente
      for (ii in seq_along(Psin)) {
        componentes[[numC]] <- Psin[ii]
        numC <- numC + 1
      }
      Psin <- NULL
    } else {
      # PILA
      pila <- Gsin[1]  # Añadimos el primer jugador del primer arco a la pila
      componentes[[numC]] <- pila  # Añadimos este jugador a la componente actual

      # Mientras no vacíe la pila busco nodos adyacentes
      while (length(pila) > 0) {
        # Marcamos el jugador como visitado
        Psin <- setdiff(Psin, pila[1])

        # Buscamos en el grafo restante sus nodos adyacentes en los arcos restantes
        m <- nrow(Gsin)
        adyacentes <- NULL
        Ausados <- NULL

        for (ii in seq_len(m)) { # en todos los arcos sin visitar
          if (pila[1] == Gsin[ii, 1]) { # si el jugador está en la primera coordenada del grafo
            adyacentes <- c(adyacentes, Gsin[ii, 2]) #añado el segundo elemento del grafo como adyacente
            Ausados <- c(Ausados, ii)
          } else if (pila[1] == Gsin[ii, 2]) { # si el jugador está en la segunda coordenada del arco
            adyacentes <- c(adyacentes, Gsin[ii, 1]) #añado el primer elemento del arco como adyacente
            Ausados <- c(Ausados, ii)
          }
        } #fin del bucle de los arcos no visitados

        # Añadimos los adyacentes a la pila, quitando el jugador que esté arriba en la pila
        pila <- c(pila[-1], adyacentes)

        # Eliminamos los arcos usados
        if (length(Ausados) > 0) {
          Gsin <- Gsin[-Ausados, , drop = FALSE]
        }

        # Añadimos los adyacentes a la componente actual
        componentes[[numC]] <- sort(unique(c(componentes[[numC]], adyacentes)))
      } # fin del bucle de la pila

      # Pasamos a la siguiente componente conexa
      numC <- numC + 1
    } # fin del bucle Gsin no vacio
  } # fin del bucle while

  return(componentes)
}
