% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap_Variance.R
\name{Bootstrap_Variance}
\alias{Bootstrap_Variance}
\title{Bootstrap_Variance}
\usage{
Bootstrap_Variance(fit, stack, M, n_boot = 100)
}
\arguments{
\item{fit}{object with corresponding vcov method (e.g. glm, coxph, survreg, etc.) from fitting to the (weighted) stacked dataset}

\item{stack}{data frame containing stacked dataset across multiple imputations. Could have 1 or M rows for each subject with complete data. Should have M rows for each subject with imputed data. Must contain the following named columns: (1) stack$.id, which correspond to a unique identifier for each subject. This column can be easily output from MICE. (2) stack$wt, which corresponds to weights assigned to each row. Standard analysis of stacked multiple imputations should set these weights to 1 over the number of times the subject appears in the stack. (3) stack$.imp, which indicates the multiply imputed dataset (from 1 to M). This column can be easily output from MICE.}

\item{M}{number of multiple imputations}

\item{n_boot}{number of bootstrap samples}
}
\value{
Variance, estimated covariance matrix accounting for within and between imputation variation
}
\description{
This function takes a dataset with stacked multiple imputation and a model fit and applies bootstrap to estimate the covariance matrix accounting for imputation uncertainty.
}
\details{
This function implements the bootstrap-based estimation method for stacked multiple imputations proposed by Dr. Paul Bernhardt in ``A Comparison of Stacked and Pooled Multiple Imputation" at the Joint Statistical Meetings, 2019.
}
\examples{
data(stackExample)

fit = stackExample$fit
stack = stackExample$stack

bootcovar = Bootstrap_Variance(fit, stack, M = 5, n_boot = 10)
VARIANCE_boot = diag(bootcovar)

}
