% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sb_gamlss.R
\name{sb_gamlss}
\alias{sb_gamlss}
\title{SelectBoost for GAMLSS (stability selection)}
\usage{
sb_gamlss(
  formula,
  data,
  family,
  mu_scope,
  sigma_scope = NULL,
  nu_scope = NULL,
  tau_scope = NULL,
  base_sigma = ~1,
  base_nu = ~1,
  base_tau = ~1,
  B = 100,
  sample_fraction = 0.7,
  pi_thr = 0.6,
  k = 2,
  direction = c("both", "forward", "backward"),
  pre_standardize = FALSE,
  use_groups = FALSE,
  c0 = 0.5,
  engine = c("stepGAIC", "glmnet", "grpreg", "sgl"),
  engine_sigma = NULL,
  engine_nu = NULL,
  engine_tau = NULL,
  grpreg_penalty = c("grLasso", "grMCP", "grSCAD"),
  sgl_alpha = 0.95,
  df_smooth = 6L,
  progress = TRUE,
  glmnet_alpha = 1,
  glmnet_family = c("gaussian", "binomial", "poisson"),
  parallel = c("none", "auto", "multisession", "multicore"),
  workers = NULL,
  trace = TRUE,
  corr_func = "cor",
  group_fun = SelectBoost::group_func_2,
  ...
)
}
\arguments{
\item{formula}{Base formula for the location \eqn{\mu} parameter (in the main model call).}

\item{data}{Data frame.}

\item{family}{A \code{gamlss.dist} family object (e.g., \code{gamlss.dist::NO()}).}

\item{mu_scope}{Formula of candidate terms for \eqn{\mu}.}

\item{sigma_scope, nu_scope, tau_scope}{Formulas of candidate terms for \eqn{\sigma}, \eqn{\nu}, \eqn{\tau}.}

\item{base_sigma, base_nu, base_tau}{Optional base (always-included) formulas for \eqn{\sigma}, \eqn{\nu}, \eqn{\tau}.}

\item{B}{Number of bootstrap subsamples for stability selection.}

\item{sample_fraction}{Fraction of rows per subsample (e.g., 0.7).}

\item{pi_thr}{Selection proportion threshold to define “stable” terms (e.g., 0.6).}

\item{k}{Penalty weight for stepwise GAIC when \code{engine = "stepGAIC"} (default 2).}

\item{direction}{Stepwise direction for \code{stepGAIC} (\code{"both"}, \code{"forward"}, \code{"backward"}).}

\item{pre_standardize}{Logical; standardize numeric predictors before penalized fits.}

\item{use_groups}{Logical; treat SelectBoost correlation groups during resampling.}

\item{c0}{SelectBoost meta-parameter controlling reweighting/thresholding (see vignette).}

\item{engine}{Engine for \eqn{\mu} (\code{"stepGAIC"}, \code{"glmnet"}, \code{"grpreg"}, \code{"sgl"}).}

\item{engine_sigma, engine_nu, engine_tau}{Optional engines for \eqn{\sigma}, \eqn{\nu}, \eqn{\tau}.}

\item{grpreg_penalty}{Group penalty for grpreg (\code{"grLasso"}, \code{"grMCP"}, \code{"grSCAD"}).}

\item{sgl_alpha}{Alpha for sparse group lasso.}

\item{df_smooth}{Degrees of freedom for proxy spline bases (\code{pb()/cs()} → \code{splines::bs(df=df_smooth)}) used only for grouped selection design.}

\item{progress}{Logical; show a progress bar in sequential runs.}

\item{glmnet_alpha}{Elastic-net mixing for glmnet (1 = lasso, 0 = ridge).}

\item{glmnet_family}{Family passed to glmnet-based selectors ("gaussian", "binomial", "poisson").}

\item{parallel}{Parallel mode (\code{"none"}, \code{"auto"}, \code{"multisession"}, `"multicore").}

\item{workers}{Integer; number of workers if parallel.}

\item{trace}{Logical; print progress messages.}

\item{corr_func}{Correlation function passed to \code{SelectBoost::boost.compcorrs}.}

\item{group_fun}{Grouping function passed to \code{SelectBoost::boost.findgroups}.}

\item{...}{Passed to underlying engines (e.g., to \code{gamlss::gamlss}, \code{glmnet}, etc.).}
}
\value{
An object of class \code{"sb_gamlss"} with elements:
\itemize{
\item \code{final_fit}: the final \code{gamlss} object.
\item \code{final_formula}: list of formulas for mu/sigma/nu/tau.
\item \code{selection}: data.frame of selection counts and proportions.
\item \code{B}, \code{sample_fraction}, \code{pi_thr}, \code{k}.
\item \code{scaler}: list with \code{center}, \code{scale}, \code{vars}, \code{response}.
}
}
\description{
SelectBoost for GAMLSS (stability selection)
}
\examples{
\dontshow{if (requireNamespace("gamlss.dist", quietly = TRUE)) withAutoprint(\{ # examplesIf}
set.seed(1)
dat <- data.frame(
  y = gamlss.dist::rNO(60, mu = 0),
  x1 = rnorm(60),
  x2 = rnorm(60),
  x3 = rnorm(60)
)
fit <- sb_gamlss(
  y ~ 1,
  data = dat,
  family = gamlss.dist::NO(),
  mu_scope = ~ x1 + x2 + gamlss::pb(x3),
  B = 8,
  pi_thr = 0.6,
  trace = FALSE
)
fit$final_formula
\dontshow{\}) # examplesIf}
}
