% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy.R
\name{get_legacy_match_history}
\alias{get_legacy_match_history}
\title{Legacy API - Profile Match History}
\usage{
get_legacy_match_history(region_id, realm_id, profile_id, host_region = "us")
}
\arguments{
\item{region_id}{A numeric argument indicating the region of the profile.
    \itemize{
        \item 1 = US Region
        \item 2 = EU Region
        \item 3 = KR/TW Region
        \item 5 = CN Region
}}

\item{realm_id}{A numeric argument indicating the realm of the profile. A realm is a subset
of the region.
 \itemize{
     \item{US Region}
         \itemize{
             \item{1 = US}
             \item{2 = LatAm}
         }
     \item{EU Region}
         \itemize{
             \item{1 = Europe}
             \item{2 = Russia}
     }
     \item{KR/TW Region}
         \itemize{
             \item{1 = Korea}
             \item{2 = Taiwan}
     }
 }}

\item{profile_id}{A unique, numeric identifier for an individual's profile.}

\item{host_region}{The host region that the API call will be sent to. For most API calls, the same data will be
returned regardless of which region the request is sent to. Must be one of "us", "eu", "kr", "tw", "cn". For more
information on regionality, refer to
\href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}.}
}
\description{
Provides information about a profile's recent match history (last 25 matches, win/loss, timestamp, etc.).
}
\note{
Although this is a legacy API call, there is no other call available to obtain a profile's match history.
}
\examples{
\donttest{
# Obtain recent 1v1 results for a profile in the U.S. region
try({
    matches <- get_legacy_match_history(region_id = 1, realm_id = 1, profile_id = 4716773)
    matches[matches$type=='1v1',"decision"]
})
}
}
\references{
\itemize{
   \item \href{https://develop.battle.net/documentation/starcraft-2/community-apis}{Blizzard Community API Documentation}
   \item \href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}
   }
}
\seealso{
Other legacy API calls: 
\code{\link{get_legacy_achievements}()},
\code{\link{get_legacy_ladders}()},
\code{\link{get_legacy_ladder}()},
\code{\link{get_legacy_profile}()},
\code{\link{get_legacy_rewards}()}
}
\concept{legacy API calls}
