% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{showOneFS}
\alias{showOneFS}
\title{show marker and haplotype dosages for one FS family}
\usage{
showOneFS(FSnr, hbresults, mrkDosage, FS, parents)
}
\arguments{
\item{FSnr}{the number of the FS family (indexes the FS list and parents)}

\item{hbresults}{a list with the haplotyping results for one haploblock:
one element of a list as returned by inferHaplotypes}

\item{mrkDosage}{a matrix of marker dosages, may contain rows for more
markers than only those in the current haploblock (the relevant markers are
specified in the hbresults list)}

\item{FS}{a list of which each item is a (character) vector with the
names of the individuals in that FS family}

\item{parents}{a (character) matrix with 2 columns and one row for each
FS family in FS, with the names of the two parents of each family}
}
\value{
a list with 3 elements:\cr
$mrkdat: a matrix with info on the marker dosages distribution in the FS. The
first two columns are for the parents: the parent name is between (brackets)
in the column name, their mrkdid (marker dosage ID) in row 1 and their marker
dosages below that. The remaining columns are for the different mrkdids
observed in the FS: the mrkdid itself in the column name, its frequency in
row 1 and its marker dosages below that. The final column gives the frequency
of individuals with one or more missing marker dosages.\cr
$hapdat: a matrix with similar layout as mrkdat, but now with the haplotype
dosages rather than the marker dosages. Some mrkdids (columns) may not have
a haplotype dosage combination assigned (if multiple possible haplotype
combinations result in the same marker dosages)\cr
usedhap: a matrix with the dosage (0 or 1) of each marker in each of the
used haplotypes; haplotype nrs in columns, markers in rows
}
\description{
show marker and haplotype dosages for one FS family and its
parents
}
\examples{
data(PolyHaplotyper_small)
# show the results of the first FS family in the first haploblock:
showOneFS(FSnr=1, hbresults=phresults[[1]], mrkDosage=phdos,
         FS=phFS, parents=phpar)

}
