% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.RollingPeriods.R
\name{table.RollingPeriods}
\alias{table.RollingPeriods}
\alias{table.TrailingPeriods}
\alias{table.TrailingPeriodsRel}
\title{Rolling Periods Summary: Statistics and Stylized Facts}
\usage{
table.RollingPeriods(
  R,
  periods = subset(c(12, 36, 60), c(12, 36, 60) < length(as.matrix(R[, 1]))),
  FUNCS = c("mean", "sd"),
  funcs.names = c("Average", "Std Dev"),
  digits = 4,
  ...
)

table.TrailingPeriodsRel(
  R,
  Rb,
  periods = subset(c(12, 36, 60), c(12, 36, 60) < length(as.matrix(R[, 1]))),
  FUNCS = c("cor", "CAPM.beta"),
  funcs.names = c("Correlation", "Beta"),
  digits = 4,
  ...
)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns}

\item{periods}{number of periods to use as rolling window(s), subset of
\code{c(3, 6, 9, 12, 18, 24, 36, 48)}}

\item{FUNCS}{list of functions to apply the rolling period to}

\item{funcs.names}{vector of function names used for labeling table rows}

\item{digits}{number of digits to round results to}

\item{\dots}{any other passthru parameters for functions specified in FUNCS}

\item{Rb}{an xts, vector, matrix, data frame, timeSeries or zoo object of
index, benchmark, portfolio, or secondary asset returns to compare against}
}
\description{
A table of estimates of rolling period return measures
}
\examples{

data(edhec)
table.TrailingPeriods(edhec[,10:13], periods=c(12,24,36))

result=table.TrailingPeriods(edhec[,10:13], periods=c(12,24,36))

\donttest{ # don't test on CRAN, since it requires Suggested packages

require("Hmisc")
textplot(format.df(result, na.blank=TRUE, numeric.dollar=FALSE, 
                   cdec=rep(3,dim(result)[2])), rmar = 0.8, cmar = 1.5,  
                   max.cex=.9, halign = "center", valign = "top", row.valign="center", 
                   wrap.rownames=15, wrap.colnames=10, mar = c(0,0,3,0)+0.1)
title(main="Trailing Period Statistics")
}
}
\seealso{
\code{\link[zoo]{rollapply}}
}
\author{
Peter Carl
}
